/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.itf.lite.backend.model.api.request.BulkDeleteSnapshotsRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestEntitySaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.response.RequestSnapshotResponse;
import org.qubership.atp.itf.lite.backend.model.entities.FileBody;
import org.qubership.atp.itf.lite.backend.model.entities.RequestSnapshot;
import org.qubership.atp.itf.lite.backend.service.RequestSnapshotService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/atp-itf-lite/api/v1/requestSnapshot"})
public class RequestSnapshotController {
    private static final Logger log = LoggerFactory.getLogger(RequestSnapshotController.class);
    private final RequestSnapshotService snapshotService;
    private final ObjectMapper objectMapper;

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),#projectId, 'UPDATE')")
    @PostMapping
    public ResponseEntity<Void> saveSnapshot(@RequestParam UUID projectId, @RequestPart(name="file", required=false) MultipartFile file, @RequestPart(name="files", required=false) List<MultipartFile> files, @RequestPart(name="snapshotEntity") @Valid RequestSnapshot snapshot) throws IOException {
        RequestEntitySaveRequest requestEntitySaveRequest = (RequestEntitySaveRequest)this.objectMapper.readValue(snapshot.getRequest(), RequestEntitySaveRequest.class);
        Optional<FileBody> fileInfo = Optional.empty();
        if (file != null) {
            fileInfo = this.snapshotService.saveFileToFileSystemAndGridFs(snapshot.getSessionId(), snapshot.getRequestId(), file, requestEntitySaveRequest.getTransportType());
        }
        this.snapshotService.saveSnapshot(snapshot, files, fileInfo);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).build();
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),#projectId, 'READ')")
    @GetMapping
    public ResponseEntity<RequestSnapshotResponse> getSnapshotById(@RequestParam UUID projectId, @RequestParam UUID sessionId, @RequestParam UUID requestId) {
        RequestSnapshotResponse response = this.snapshotService.getSnapshot(sessionId, requestId);
        return response == null ? ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).build() : ResponseEntity.ok((Object)response);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),#projectId, 'READ')")
    @DeleteMapping
    public ResponseEntity<Void> deleteSnapshotBySessionId(@RequestParam UUID projectId, @RequestParam UUID requestId, @RequestParam UUID sessionId) {
        this.snapshotService.deleteSnapshotByRequestSnapshotKey(sessionId, requestId);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).build();
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),#projectId, 'READ')")
    @PostMapping(value={"/bulkDelete"})
    public ResponseEntity<Void> bulkDeleteSnapshots(@RequestParam UUID projectId, @RequestBody BulkDeleteSnapshotsRequest bulkDeleteSnapshotsRequest, @RequestParam UUID sessionId) {
        this.snapshotService.bulkDeleteSnapshots(bulkDeleteSnapshotsRequest, sessionId);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).build();
    }

    public RequestSnapshotController(RequestSnapshotService snapshotService, ObjectMapper objectMapper) {
        this.snapshotService = snapshotService;
        this.objectMapper = objectMapper;
    }
}

