/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.controllers;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.itf.lite.backend.model.entities.user.UserSettings;
import org.qubership.atp.itf.lite.backend.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/atp-itf-lite/api/v1/user-settings"})
public class UserController {
    private static final Logger log = LoggerFactory.getLogger(UserController.class);
    private final UserService userService;

    @AuditAction(auditAction="Save settings for the user with id '{{#setting.userId}}'")
    @PreAuthorize(value="@entityAccess.checkAccess(#projectId, 'CREATE') || @entityAccess.checkAccess(#projectId, 'UPDATE')")
    @PostMapping
    public ResponseEntity<UserSettings> saveUserSettings(@RequestParam UUID projectId, @RequestBody UserSettings setting, @RequestHeader(value="Authorization") String token) {
        return new ResponseEntity((Object)this.userService.saveUserSettings(setting, token), HttpStatus.OK);
    }

    @AuditAction(auditAction="Get user settings")
    @PreAuthorize(value="@entityAccess.checkAccess(#projectId,'READ')")
    @GetMapping
    public ResponseEntity<List<UserSettings>> getSettingsByUser(@RequestParam UUID projectId, @RequestHeader(value="Authorization") String token) {
        List<UserSettings> setting = this.userService.getSettingsByUser(token);
        return Objects.nonNull(setting) ? ResponseEntity.ok(setting) : ResponseEntity.notFound().build();
    }

    public UserController(UserService userService) {
        this.userService = userService;
    }
}

