/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.converters;

import clover.org.apache.commons.lang.StringUtils;
import java.util.List;
import java.util.Objects;
import org.qubership.atp.itf.lite.backend.converters.curl.CurlOptions;
import org.qubership.atp.itf.lite.backend.enums.ValueType;
import org.qubership.atp.itf.lite.backend.model.api.request.HttpRequestEntitySaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.http.HttpHeaderSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.http.HttpParamSaveRequest;
import org.qubership.atp.itf.lite.backend.model.entities.FileBody;
import org.qubership.atp.itf.lite.backend.model.entities.RequestBody;
import org.qubership.atp.itf.lite.backend.model.entities.http.FormDataPart;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpMethod;
import org.qubership.atp.itf.lite.backend.utils.RequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class RequestToCurlFormatConverter
implements CurlOptions {
    private static final Logger log = LoggerFactory.getLogger(RequestToCurlFormatConverter.class);

    public String convertRequestToCurlStringBuilder(HttpRequestEntitySaveRequest httpRequest) {
        StringBuilder curlString = this.initialCurlRequest();
        this.addRequestMethod(curlString, httpRequest.getHttpMethod());
        this.addRequestHeaders(curlString, httpRequest.getRequestHeaders());
        if (httpRequest.getBody() != null) {
            this.addRequestBody(curlString, httpRequest.getBody());
        }
        this.addUrlWithParameters(curlString, httpRequest.getUrl(), httpRequest.getRequestParams());
        return curlString.toString();
    }

    public StringBuilder initialCurlRequest() {
        return new StringBuilder("curl ");
    }

    public void addRequestHeaders(StringBuilder currentCurlRequest, List<HttpHeaderSaveRequest> headers) {
        if (CollectionUtils.isEmpty(headers)) {
            return;
        }
        headers.forEach(header -> {
            if (!header.isDisabled() && !StringUtils.isEmpty((String)header.getKey())) {
                if (StringUtils.isEmpty((String)header.getValue())) {
                    currentCurlRequest.append(String.format("-H \"%s;\" ", header.getKey()));
                } else {
                    currentCurlRequest.append(String.format("-H \"%s: %s\" ", header.getKey(), header.getValue()));
                }
            }
        });
    }

    public void addRequestMethod(StringBuilder currentCurlRequest, HttpMethod method) {
        currentCurlRequest.append("-X").append(" ").append(method.name()).append(" ");
    }

    public void addRequestBody(StringBuilder currentCurlRequest, RequestBody body) {
        if (Objects.nonNull(body) && Objects.nonNull((Object)body.getType())) {
            switch (body.getType()) {
                case FORM_DATA: {
                    this.addFormDataRequestBody(currentCurlRequest, body.getFormDataBody());
                    break;
                }
                case Binary: {
                    FileBody fileBody = body.getBinaryBody();
                    if (!Objects.nonNull(fileBody) || StringUtils.isEmpty((String)fileBody.getFileName())) break;
                    currentCurlRequest.append(String.format("--data-binary \"@%s\" ", fileBody.getFileName()));
                    break;
                }
                case GraphQL: {
                    currentCurlRequest.append("-d").append(" '").append(body.composeGraphQlBody()).append("' ");
                    break;
                }
                default: {
                    if (StringUtils.isEmpty((String)body.getContent())) break;
                    currentCurlRequest.append("-d").append(" '").append(body.getContent()).append("' ");
                }
            }
        }
    }

    private void addFormDataRequestBody(StringBuilder curlBuilder, List<FormDataPart> formDataParts) {
        if (!CollectionUtils.isEmpty(formDataParts)) {
            for (FormDataPart formDataPart : formDataParts) {
                if (formDataPart.isDisabled()) continue;
                curlBuilder.append(String.format("-F '%s=", formDataPart.getKey()));
                if (ValueType.FILE.equals((Object)formDataPart.getType())) {
                    curlBuilder.append("@");
                }
                curlBuilder.append(formDataPart.getValue());
                if (!StringUtils.isEmpty((String)formDataPart.getContentType())) {
                    curlBuilder.append(";type=").append(formDataPart.getContentType());
                }
                curlBuilder.append("' ");
            }
        }
    }

    public void addUrlWithParameters(StringBuilder currentCurlRequest, String url, List<HttpParamSaveRequest> requestParams) {
        UriComponentsBuilder uriComponentsBuilder = RequestUtils.buildRequestWithParameters(url, requestParams);
        currentCurlRequest.append("'").append(uriComponentsBuilder.encode().toUriString()).append("'");
    }
}

