/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.dataaccess.repository;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.CustomFolderRepository;
import org.qubership.atp.itf.lite.backend.model.entities.Folder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class CustomFolderRepositoryImpl
implements CustomFolderRepository {
    private static final Logger log = LoggerFactory.getLogger(CustomFolderRepositoryImpl.class);
    private final EntityManager em;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID getFolderIdPyPath(UUID projectId, List<String> path) {
        if (CollectionUtils.isEmpty(path)) {
            throw new IllegalArgumentException("path can not be empty");
        }
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(UUID.class);
        Root folder = cq.from(Folder.class);
        cq.select((Selection)folder.get("id"));
        if (path.size() == 1) {
            cq.where(new Predicate[]{cb.and((Expression)cb.equal((Expression)folder.get("name"), (Object)path.get(0)), (Expression)cb.equal((Expression)folder.get("projectId"), (Object)projectId)), cb.isNull((Expression)folder.get("parentId"))});
        } else {
            Subquery<UUID> subquery = this.getParentFolder(cb, (Subquery<UUID>)cq.subquery(UUID.class), path, path.size() - 2, projectId);
            cq.where((Expression)cb.and((Expression)cb.equal((Expression)folder.get("name"), (Object)path.get(path.size() - 1)), (Expression)folder.get("parentId").in(new Expression[]{subquery})));
        }
        cq.orderBy(new Order[]{cb.asc((Expression)folder.get("order"))});
        try {
            UUID uUID = (UUID)this.em.createQuery(cq).setMaxResults(1).getSingleResult();
            return uUID;
        }
        finally {
            this.em.clear();
        }
    }

    private Subquery<UUID> getParentFolder(CriteriaBuilder cb, Subquery<UUID> parentFolderSq, List<String> path, int currentIndex, UUID projectId) {
        Root parentFolder = parentFolderSq.from(Folder.class);
        parentFolderSq.select((Expression)parentFolder.get("id"));
        if (currentIndex == 0) {
            return parentFolderSq.where(new Predicate[]{cb.and((Expression)cb.equal((Expression)parentFolder.get("name"), (Object)path.get(currentIndex)), (Expression)cb.equal((Expression)parentFolder.get("projectId"), (Object)projectId)), cb.isNull((Expression)parentFolder.get("parentId"))});
        }
        Subquery<UUID> subquery = this.getParentFolder(cb, (Subquery<UUID>)parentFolderSq.subquery(UUID.class), path, currentIndex - 1, projectId);
        return parentFolderSq.where((Expression)cb.and((Expression)cb.equal((Expression)parentFolder.get("name"), (Object)path.get(currentIndex)), (Expression)parentFolder.get("parentId").in(new Expression[]{subquery})));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<UUID> findHeirsIdsByIdIn(Collection<UUID> ids) {
        Query query = this.em.createNativeQuery("WITH RECURSIVE heirs(id, parent_id) AS (\n\tSELECT folder.id, folder.parent_id\n\tFROM public.folders folder\n\tWHERE folder.id IN :ids\n\tUNION ALL\n\tSELECT child.id, child.parent_id\n\tFROM public.folders child\n\tJOIN heirs parent\n\tON parent.id = child.parent_id\n)\nSELECT CAST(id as text) from heirs");
        query.setParameter("ids", ids);
        try {
            List result = query.getResultList();
            Set<UUID> set = result.stream().map(UUID::fromString).collect(Collectors.toSet());
            return set;
        }
        finally {
            this.em.clear();
        }
    }

    public CustomFolderRepositoryImpl(EntityManager em) {
        this.em = em;
    }
}

