/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.dataaccess.repository;

import clover.org.apache.commons.collections.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.CustomRequestExecutionRepository;
import org.qubership.atp.itf.lite.backend.enums.SortType;
import org.qubership.atp.itf.lite.backend.enums.TransportType;
import org.qubership.atp.itf.lite.backend.model.entities.history.HistoryFilteringParams;
import org.qubership.atp.itf.lite.backend.model.entities.history.HistorySearchRequest;
import org.qubership.atp.itf.lite.backend.model.entities.history.PaginatedResponse;
import org.qubership.atp.itf.lite.backend.model.entities.history.RequestExecution;
import org.qubership.atp.itf.lite.backend.model.entities.history.SortParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class CustomRequestExecutionRepositoryImpl
implements CustomRequestExecutionRepository {
    private static final Logger log = LoggerFactory.getLogger(CustomRequestExecutionRepositoryImpl.class);
    private static final String REQUEST_EXECUTION_FILTER_COLUMN_PROJECT_ID = "projectId";
    private static final String REQUEST_EXECUTION_FILTER_COLUMN_EXECUTOR = "executor";
    private static final String REQUEST_EXECUTION_FILTER_COLUMN_REQUEST_NAME = "name";
    private static final String REQUEST_EXECUTION_FILTER_COLUMN_TRANSPORT_TYPE = "transportType";
    private static final String REQUEST_EXECUTION_FILTER_COLUMN_EXECUTED_WHEN = "executedWhen";
    private static final String REQUEST_EXECUTION_FILTER_COLUMN_TIMESTAMP = "TIMESTAMP";
    EntityManager entityManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PaginatedResponse<RequestExecution> findAllRequestExecutions(HistorySearchRequest request) {
        long total;
        List requestExecutionList;
        List<TransportType> types;
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(RequestExecution.class);
        Root requestExecution = criteriaQuery.from(RequestExecution.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        predicates.add(criteriaBuilder.equal((Expression)requestExecution.get(REQUEST_EXECUTION_FILTER_COLUMN_PROJECT_ID), (Object)request.getProjectId()));
        HistoryFilteringParams historyFilteringParams = request.getFilters();
        List<String> executors = historyFilteringParams.getExecutor();
        if (CollectionUtils.isNotEmpty(executors)) {
            CriteriaBuilder.In inClause = criteriaBuilder.in((Expression)requestExecution.get(REQUEST_EXECUTION_FILTER_COLUMN_EXECUTOR));
            executors.forEach(arg_0 -> ((CriteriaBuilder.In)inClause).value(arg_0));
            predicates.add(inClause);
        }
        if (CollectionUtils.isNotEmpty(types = historyFilteringParams.getType())) {
            CriteriaBuilder.In inClause = criteriaBuilder.in((Expression)requestExecution.get(REQUEST_EXECUTION_FILTER_COLUMN_TRANSPORT_TYPE));
            types.forEach(arg_0 -> ((CriteriaBuilder.In)inClause).value(arg_0));
            predicates.add(inClause);
        }
        criteriaQuery.where(predicates.toArray(new Predicate[0]));
        List<SortParams> sortParams = request.getSort();
        if (CollectionUtils.isNotEmpty(sortParams)) {
            sortParams.forEach(param -> {
                if (REQUEST_EXECUTION_FILTER_COLUMN_TIMESTAMP.equals(param.getColumn())) {
                    SortType sortType = param.getSortType();
                    if (SortType.ASC.equals((Object)sortType)) {
                        criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)requestExecution.get(REQUEST_EXECUTION_FILTER_COLUMN_EXECUTED_WHEN))});
                    } else if (SortType.DESC.equals((Object)sortType)) {
                        criteriaQuery.orderBy(new Order[]{criteriaBuilder.desc((Expression)requestExecution.get(REQUEST_EXECUTION_FILTER_COLUMN_EXECUTED_WHEN))});
                    }
                }
            });
        }
        try {
            requestExecutionList = this.entityManager.createQuery(criteriaQuery).setFirstResult(request.getOffset()).setMaxResults(request.getLimit()).getResultList();
        }
        finally {
            this.entityManager.clear();
        }
        CriteriaQuery criteriaQueryTotal = criteriaBuilder.createQuery(Long.class);
        criteriaQueryTotal.select((Selection)criteriaBuilder.count((Expression)criteriaQueryTotal.from(RequestExecution.class)));
        ArrayList<Predicate> criteriaQueryPredicates = new ArrayList<Predicate>();
        criteriaQueryPredicates.add(criteriaBuilder.equal((Expression)requestExecution.get(REQUEST_EXECUTION_FILTER_COLUMN_PROJECT_ID), (Object)request.getProjectId()));
        TypedQuery query = this.entityManager.createQuery(criteriaQueryTotal.where(criteriaQueryPredicates.toArray(new Predicate[0])));
        try {
            total = (Long)query.getSingleResult();
        }
        finally {
            this.entityManager.clear();
        }
        return new PaginatedResponse<RequestExecution>(total, requestExecutionList);
    }

    public CustomRequestExecutionRepositoryImpl(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

