/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.dataaccess.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.qubership.atp.itf.lite.backend.configuration.GridFsProperties;
import org.qubership.atp.itf.lite.backend.model.entities.FileBody;
import org.qubership.atp.itf.lite.backend.model.entities.gridfs.FileData;
import org.qubership.atp.itf.lite.backend.model.entities.gridfs.FileInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository(value="itf-lite-gridfs-repository")
public class GridFsRepository {
    private static final Logger log = LoggerFactory.getLogger(GridFsRepository.class);
    private static final String REQUEST_ID = "requestId";
    private static final String SESSION_REQUEST_ID = "sessionRequestId";
    private static final String SESSION_ID = "sessionId";
    private static final String METADATA_REQUEST_ID = "metadata.requestId";
    private static final String METADATA_SESSION_ID = "metadata.sessionId";
    private static final String METADATA_SESSION_REQUEST_ID = "metadata.sessionRequestId";
    private static final String UPLOAD_DATE = "uploadDate";
    private static final String METADATA_UPLOAD_DATE = "metadata.uploadDate";
    private static final String ITF_LITE_DICTIONARY = "itfLiteDictionary";
    private static final String ITF_LITE_FILE = "itfLiteFile";
    private static final String BINARY_FILE = "binary";
    private static final String FILE_TYPE = "fileType";
    private static final String FILE_ID = "fileId";
    private static final String HISTORY = "history";
    private static final String CONTENT_TYPE = "contentType";
    private static final String METADATA_FILE_TYPE = "metadata.fileType";
    private static final String METADATA_FILE_ID = "metadata.fileId";
    private static final String METADATA_ITF_LITE_DICTIONARY = "metadata.itfLiteDictionary";
    private static final String TYPE = "type";
    private static final String CONTENT_TYPE_FILE = "file";
    private final GridFSBucket gridFsBucket;
    private final MongoDatabase gridFsMongoDatabase;
    private final GridFsProperties gridFsProperties;
    private final ObjectMapper objectMapper;

    @Autowired
    public GridFsRepository(GridFSBucket gridFsBucket, MongoDatabase gridFsMongoDatabase, GridFsProperties gridFsProperties, ObjectMapper objectMapper) {
        this.gridFsBucket = gridFsBucket;
        this.gridFsMongoDatabase = gridFsMongoDatabase;
        this.gridFsProperties = gridFsProperties;
        this.objectMapper = objectMapper;
    }

    public UUID saveDictionaryByRequestId(String creationTime, UUID requestId, InputStream dictionaryInputStream, String dictionaryName) {
        Document metadata = new Document(ITF_LITE_DICTIONARY, (Object)ITF_LITE_DICTIONARY).append(CONTENT_TYPE, (Object)CONTENT_TYPE_FILE);
        return this.saveFileWithMetadata(metadata, dictionaryName, creationTime, requestId, REQUEST_ID, dictionaryInputStream);
    }

    public UUID saveDictionaryBySessionIdAndSessionRequestId(String creationTime, UUID sessionId, UUID sessionRequestId, InputStream dictionaryInputStream, String dictionaryName) {
        Document metadata = new Document(ITF_LITE_DICTIONARY, (Object)ITF_LITE_DICTIONARY).append(CONTENT_TYPE, (Object)CONTENT_TYPE_FILE).append(SESSION_ID, (Object)sessionId).append(SESSION_REQUEST_ID, (Object)sessionRequestId);
        return this.saveFileWithMetadata(metadata, dictionaryName, creationTime, dictionaryInputStream);
    }

    public FileBody saveBinaryByRequestId(String creationTime, UUID requestId, InputStream fileInputStream, String fileName, String contentType) {
        Document metadata = new Document(FILE_TYPE, (Object)BINARY_FILE).append(CONTENT_TYPE, (Object)contentType);
        UUID fileId = this.saveFileWithMetadata(metadata, fileName, creationTime, requestId, REQUEST_ID, fileInputStream);
        return new FileBody(fileName, fileId);
    }

    public FileBody saveBinaryBySessionIdAndSessionRequestId(String creationTime, UUID sessionId, UUID sessionRequestId, InputStream fileInputStream, String fileName, String contentType) {
        Document metadata = new Document(FILE_TYPE, (Object)BINARY_FILE).append(CONTENT_TYPE, (Object)contentType).append(SESSION_ID, (Object)sessionId).append(SESSION_REQUEST_ID, (Object)sessionRequestId);
        UUID fileId = this.saveFileWithMetadata(metadata, fileName, creationTime, fileInputStream);
        return new FileBody(fileName, fileId);
    }

    public UUID saveHistoryBinary(String creationTime, InputStream fileInputStream, String fileName) {
        Document metadata = new Document().append(FILE_TYPE, (Object)BINARY_FILE).append(HISTORY, (Object)true).append(CONTENT_TYPE, (Object)CONTENT_TYPE_FILE);
        return this.saveFileWithMetadata(metadata, fileName, creationTime, null, REQUEST_ID, fileInputStream);
    }

    public void saveByFileInfo(FileInfo fileInfo, InputStream inputStream) {
        GridFSUploadOptions uploadOptions = new GridFSUploadOptions().chunkSizeBytes(this.gridFsProperties.getChunkSizeBytes()).metadata(new Document().append(TYPE, (Object)CONTENT_TYPE_FILE).append(UPLOAD_DATE, (Object)LocalDateTime.now().toString()).append(CONTENT_TYPE, (Object)fileInfo.getContentType()).append(REQUEST_ID, (Object)fileInfo.getRequestId()).append(FILE_ID, (Object)(fileInfo.getFileId() == null ? UUID.randomUUID() : fileInfo.getFileId())).append(FILE_TYPE, (Object)fileInfo.getFileType()));
        this.gridFsBucket.uploadFromStream(fileInfo.getFileName(), inputStream, uploadOptions);
    }

    private UUID saveFileWithMetadata(Document metadata, String fileName, String creationTime, UUID id, String metadataIdName, InputStream fileInputStream) {
        UUID fileId = UUID.randomUUID();
        GridFSUploadOptions uploadOptions = new GridFSUploadOptions().chunkSizeBytes(this.gridFsProperties.getChunkSizeBytes()).metadata(metadata.append(TYPE, (Object)CONTENT_TYPE_FILE).append(UPLOAD_DATE, (Object)creationTime).append(metadataIdName, (Object)id).append(FILE_ID, (Object)fileId));
        this.gridFsBucket.uploadFromStream(fileName, fileInputStream, uploadOptions);
        return fileId;
    }

    private UUID saveFileWithMetadata(Document metadata, String fileName, String creationTime, InputStream fileInputStream) {
        UUID fileId = UUID.randomUUID();
        GridFSUploadOptions uploadOptions = new GridFSUploadOptions().chunkSizeBytes(this.gridFsProperties.getChunkSizeBytes()).metadata(metadata.append(TYPE, (Object)CONTENT_TYPE_FILE).append(UPLOAD_DATE, (Object)creationTime).append(FILE_ID, (Object)fileId));
        this.gridFsBucket.uploadFromStream(fileName, fileInputStream, uploadOptions);
        return fileId;
    }

    public ObjectId saveFileByRequestId(String creationTime, UUID requestId, InputStream fileInputStream, String fileName, UUID fileId) {
        return this.saveFile(creationTime, requestId, REQUEST_ID, fileInputStream, fileName, fileId);
    }

    public ObjectId saveFileBySessionId(String creationTime, UUID sessionId, InputStream fileInputStream, String fileName, UUID fileId) {
        return this.saveFile(creationTime, sessionId, SESSION_ID, fileInputStream, fileName, fileId);
    }

    public ObjectId saveFile(String creationTime, UUID id, String metadataIdName, InputStream fileInputStream, String fileName, UUID fileId) {
        GridFSUploadOptions uploadOptions = new GridFSUploadOptions().chunkSizeBytes(this.gridFsProperties.getChunkSizeBytes()).metadata(new Document(TYPE, (Object)CONTENT_TYPE_FILE).append(UPLOAD_DATE, (Object)creationTime).append(CONTENT_TYPE, (Object)CONTENT_TYPE_FILE).append(metadataIdName, (Object)id).append(ITF_LITE_FILE, (Object)ITF_LITE_FILE).append(FILE_ID, (Object)fileId));
        return this.gridFsBucket.uploadFromStream(fileName, fileInputStream, uploadOptions);
    }

    public Optional<FileData> getRequestFileData(UUID requestId) {
        Document filter = this.getFilter(requestId, METADATA_REQUEST_ID);
        return this.getFileDataByFilter(filter);
    }

    public Optional<FileData> getFileDataByFileId(UUID fileId) {
        Document filter = new Document().append(METADATA_FILE_ID, (Object)fileId);
        return this.getFileDataByFilter(filter);
    }

    public Map<UUID, List<FileInfo>> getFileInfosByRequestIds(Set<UUID> requestIds) {
        HashMap<UUID, List<FileInfo>> filesToRequestId = new HashMap<UUID, List<FileInfo>>();
        requestIds.forEach(id -> filesToRequestId.put((UUID)id, this.getFileInfosByRequestId((UUID)id)));
        return filesToRequestId;
    }

    public List<FileInfo> getFileInfosByRequestId(UUID requestId) {
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        this.findAllByFilter((Bson)this.getFilter(requestId, METADATA_REQUEST_ID)).forEach(gridFsFile -> {
            Document metadata = gridFsFile.getMetadata();
            if (metadata != null) {
                try {
                    FileInfo info = (FileInfo)this.objectMapper.readValue(this.objectMapper.writeValueAsString((Object)metadata), FileInfo.class);
                    info.setId(gridFsFile.getId());
                    info.setFileName(gridFsFile.getFilename());
                    fileInfos.add(info);
                }
                catch (Exception e) {
                    log.error("Error when creating file info for request {}. Metadata {}", new Object[]{requestId, metadata, e});
                }
            }
        });
        return fileInfos;
    }

    public FileInfo getFileInfoByRequestId(UUID requestId) {
        return this.getFileInfo(requestId, METADATA_REQUEST_ID);
    }

    public FileInfo getFileInfoByFileId(UUID fileId) {
        return this.getFileInfo(fileId, METADATA_FILE_ID);
    }

    public FileInfo getFileInfo(UUID id, String metaInfoIdName) {
        GridFSFile gridFsFile = this.findByFilter(this.getFilter(id, metaInfoIdName));
        Document metadata = gridFsFile.getMetadata();
        if (metadata != null) {
            try {
                FileInfo info = (FileInfo)this.objectMapper.readValue(this.objectMapper.writeValueAsString((Object)metadata), FileInfo.class);
                info.setId(gridFsFile.getId());
                info.setFileName(gridFsFile.getFilename());
                info.setSize(gridFsFile.getLength());
                return info;
            }
            catch (Exception e) {
                log.error("Error when creating file info for {}:{}. Metadata {}", new Object[]{metaInfoIdName, id, metadata, e});
            }
        }
        return null;
    }

    public Map<UUID, InputStream> getFileByFileInfos(List<FileInfo> fileInfos) {
        HashMap<UUID, InputStream> filesToFileId = new HashMap<UUID, InputStream>();
        fileInfos.forEach(file -> {
            if (file.getFileId() == null) {
                UUID fileId = UUID.randomUUID();
                filesToFileId.put(fileId, (InputStream)this.gridFsBucket.openDownloadStream(file.getId()));
                file.setFileId(fileId);
            }
            filesToFileId.put(file.getFileId(), (InputStream)this.gridFsBucket.openDownloadStream(file.getId()));
        });
        return filesToFileId;
    }

    public InputStream getFileByFileInfo(FileInfo fileInfo) {
        return this.gridFsBucket.openDownloadStream(fileInfo.getId());
    }

    public void removeFileByRequestId(UUID requestId) {
        Document filter = this.getFilter(requestId, METADATA_REQUEST_ID);
        GridFSFile result = this.findByFilter(filter);
        if (Objects.nonNull(result)) {
            this.gridFsBucket.delete(result.getObjectId());
        }
    }

    public void removeAllFilesByRequestId(UUID requestId) {
        Document filter = this.getFilter(requestId, METADATA_REQUEST_ID);
        List<GridFSFile> result = this.findAllByFilter((Bson)filter);
        if (!CollectionUtils.isEmpty(result)) {
            result.forEach(file -> this.gridFsBucket.delete(file.getObjectId()));
        }
    }

    public void removeAllFilesBySessionIdAndSessionRequestId(UUID sessionId, UUID sessionRequestId) {
        Document filter = this.getFilter(sessionId, METADATA_SESSION_ID);
        List<GridFSFile> result = this.findAllByFilter((Bson)(filter = this.addFilter(filter, sessionRequestId, METADATA_SESSION_REQUEST_ID)));
        if (!CollectionUtils.isEmpty(result)) {
            result.forEach(file -> this.gridFsBucket.delete(file.getObjectId()));
        }
    }

    public void removeFileByFileId(UUID fileId) {
        Document filter = new Document(METADATA_FILE_ID, (Object)fileId);
        GridFSFile result = this.findByFilter(filter);
        if (Objects.nonNull(result)) {
            this.gridFsBucket.delete(result.getObjectId());
        }
    }

    public void removeBinaryFileByRequestId(UUID requestId) {
        Document filter = this.getFilter(requestId, METADATA_REQUEST_ID);
        filter.append(METADATA_FILE_TYPE, (Object)BINARY_FILE);
        GridFSFile result = this.findByFilter(filter);
        if (Objects.nonNull(result)) {
            this.gridFsBucket.delete(result.getObjectId());
        }
    }

    public void removeFilesByDate(Integer days) {
        LocalDateTime validUploadDate = LocalDateTime.now().minusDays(days.intValue());
        Document filter = new Document().append(METADATA_ITF_LITE_DICTIONARY, (Object)ITF_LITE_DICTIONARY).append(METADATA_UPLOAD_DATE, (Object)("{$lt: " + validUploadDate + "}"));
        List<GridFSFile> result = this.findAllByFilter((Bson)filter);
        if (!CollectionUtils.isEmpty(result)) {
            result.forEach(file -> this.gridFsBucket.delete(file.getObjectId()));
        }
    }

    private FileData createFileDataFromFileInDb(GridFSFile file) {
        ByteArrayOutputStream bos = this.downloadFileFromDbToByteStream(file);
        return this.composeFileDataFromGridFsFileAndItsContent(file, bos);
    }

    private ByteArrayOutputStream downloadFileFromDbToByteStream(GridFSFile file) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.gridFsBucket.downloadToStream(file.getObjectId(), (OutputStream)bos);
        return bos;
    }

    private FileData composeFileDataFromGridFsFileAndItsContent(GridFSFile file, ByteArrayOutputStream bos) {
        FileData fileData = new FileData();
        fileData.setContent(bos.toByteArray());
        fileData.setFileName(file.getFilename());
        Document metadata = file.getMetadata();
        if (metadata != null) {
            if (metadata.containsKey((Object)FILE_ID)) {
                fileData.setFileId(UUID.fromString(String.valueOf(metadata.get((Object)FILE_ID))));
            }
            fileData.setContentType(metadata.getString((Object)CONTENT_TYPE));
        }
        return fileData;
    }

    private Optional<FileData> getFileDataByFilter(Document filter) {
        GridFSFile gridFsDictionary = this.findByFilter(filter);
        if (Objects.isNull(gridFsDictionary)) {
            log.debug("Cannot get dictionary by filter {}", (Object)filter);
            return Optional.empty();
        }
        FileData fileData = this.createFileDataFromFileInDb(gridFsDictionary);
        log.debug("File was found {} by filter {}", (Object)gridFsDictionary.getFilename(), (Object)filter);
        return Optional.of(fileData);
    }

    private GridFSFile findByFilter(Document filter) {
        return (GridFSFile)this.gridFsBucket.find((Bson)filter).first();
    }

    private List<GridFSFile> findAllByFilter(Bson filter) {
        ArrayList gridFsFiles = new ArrayList();
        return (List)this.gridFsBucket.find(filter).into(gridFsFiles);
    }

    private Document getFilter(UUID id, String metadataField) {
        return new Document().append(metadataField, (Object)id);
    }

    private Document addFilter(Document document, UUID id, String metadataField) {
        return document.append(metadataField, (Object)id);
    }

    public List<GridFSFile> findAllFilesByRequestId(UUID requestId) {
        Document filter = new Document().append(METADATA_REQUEST_ID, (Object)requestId);
        return this.findAllByFilter((Bson)filter);
    }

    public List<FileData> getFilesDataList(UUID requestId) {
        List<GridFSFile> files = this.findAllFilesByRequestId(requestId);
        ArrayList<FileData> res = new ArrayList<FileData>();
        files.forEach(gridFSFile -> res.add(this.createFileDataFromFileInDb((GridFSFile)gridFSFile)));
        return res;
    }

    public GridFSFile findByFileId(UUID fileId) {
        Document filter = new Document().append(METADATA_FILE_ID, (Object)fileId);
        return this.findByFilter(filter);
    }

    public UUID copyFileWithFileId(UUID fileId, UUID newRequestId) {
        log.debug("Copying file with id {} to request id {}", (Object)fileId, (Object)newRequestId);
        GridFSFile file = this.findByFileId(fileId);
        if (Objects.nonNull(file)) {
            UUID newFileId = UUID.randomUUID();
            FileData fd = this.createFileDataFromFileInDb(file);
            this.saveFileByRequestId((String)file.getMetadata().get((Object)UPLOAD_DATE, String.class), Objects.nonNull(newRequestId) ? newRequestId : (UUID)file.getMetadata().get((Object)REQUEST_ID, UUID.class), new ByteArrayInputStream(fd.getContent()), file.getFilename(), newFileId);
            return newFileId;
        }
        log.warn("File with id {} not found", (Object)fileId);
        return null;
    }

    public void moveFileFromSnapshotToRequest(UUID sessionId, UUID requestId) {
        MongoCollection filesCollection = this.gridFsMongoDatabase.getCollection("fs.files");
        filesCollection.updateMany(Filters.and((Bson[])new Bson[]{Filters.eq((String)METADATA_SESSION_ID, (Object)sessionId), Filters.eq((String)METADATA_SESSION_REQUEST_ID, (Object)requestId)}), Updates.combine((Bson[])new Bson[]{Updates.set((String)METADATA_REQUEST_ID, (Object)requestId), Updates.unset((String)METADATA_SESSION_ID), Updates.unset((String)METADATA_SESSION_REQUEST_ID)}));
    }

    public void removeFileBySessionId(UUID sessionId) {
        Document filter = this.getFilter(sessionId, METADATA_SESSION_ID);
        GridFSFile result = this.findByFilter(filter);
        if (Objects.nonNull(result)) {
            this.gridFsBucket.delete(result.getObjectId());
        }
    }

    public void bulkRemoveFilesBySnapshotKeys(UUID sessionId, List<UUID> requestIds) {
        ArrayList filters = new ArrayList();
        requestIds.forEach(requestId -> filters.add(Filters.and((Bson[])new Bson[]{this.getFilter((UUID)requestId, METADATA_SESSION_REQUEST_ID), this.getFilter(sessionId, METADATA_SESSION_ID)})));
        Bson filter = Filters.or(filters);
        List<GridFSFile> result = this.findAllByFilter(filter);
        if (!CollectionUtils.isEmpty(result)) {
            result.forEach(file -> this.gridFsBucket.delete(file.getObjectId()));
        }
    }

    public Optional<FileData> getFileDataBySessionIdAndRequestId(UUID sessionId, UUID sessionRequestId) {
        Document filter = new Document().append(METADATA_SESSION_ID, (Object)sessionId);
        filter = this.addFilter(filter, sessionRequestId, METADATA_SESSION_REQUEST_ID);
        return this.getFileDataByFilter(filter);
    }
}

