/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.dataaccess.repository;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.transaction.Transactional;
import org.javers.spring.annotation.JaversSpringDataAuditable;
import org.qubership.atp.itf.lite.backend.enums.TransportType;
import org.qubership.atp.itf.lite.backend.model.RequestRuntimeOptions;
import org.qubership.atp.itf.lite.backend.model.entities.Request;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

@JaversSpringDataAuditable
public interface RequestRepository
extends JpaRepository<Request, UUID>,
JpaSpecificationExecutor<Request> {
    public List<Request> findAllByProjectId(UUID var1);

    public Optional<Request> findByProjectIdAndId(UUID var1, UUID var2);

    @Query(value="select new org.qubership.atp.itf.lite.backend.model.RequestRuntimeOptions(r.disableSslCertificateVerification, r.disableSslClientCertificate, r.disableFollowingRedirect, r.disableAutoEncoding) from Request r where r.id = :id")
    public Optional<RequestRuntimeOptions> getRequestRuntimeOptionsById(UUID var1);

    public List<Request> findAllByProjectIdAndFolderId(UUID var1, UUID var2);

    public List<Request> findAllByFolderIdIn(Set<UUID> var1);

    public List<Request> findAllByProjectIdAndNameContains(UUID var1, String var2);

    public List<Request> findAllByFolderId(UUID var1);

    public List<Request> findAllByFolderIdOrderByOrder(UUID var1);

    public List<Request> findAllByIdIn(Set<UUID> var1);

    @Transactional
    public void deleteByIdIn(Set<UUID> var1);

    public List<Request> findAllByProjectIdAndIdIn(UUID var1, Set<UUID> var2);

    public List<Request> findAllByProjectIdAndIdInOrderByOrder(UUID var1, Set<UUID> var2);

    @Query(value="select r.transportType from Request r where r.id = :id")
    public TransportType findTransportType(UUID var1);

    @Query(value="select max(r.order) from Request r where r.projectId = :projectId and r.folderId = :folderId")
    public Integer findMaxOrder(UUID var1, UUID var2);

    @Query(value="select max(r.order) from Request r where r.projectId = :projectId")
    public Integer findMaxOrder(UUID var1);

    public Request getByProjectIdAndSourceId(UUID var1, UUID var2);

    public List<Request> findAllByName(String var1);

    @Modifying
    @Query(value="update Request r set r.isAutoCookieDisabled = :autoCookieDisabled where r.folderId in :ids")
    public void updateAutoCookieDisabledByFolderIdIn(boolean var1, Set<UUID> var2);
}

