/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.dataaccess.validators;

import java.util.UUID;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.FolderRepository;
import org.qubership.atp.itf.lite.backend.model.api.request.FolderUpsetRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@Component
public class FolderCreationRequestValidator
implements Validator {
    private static final Logger log = LoggerFactory.getLogger(FolderCreationRequestValidator.class);
    private final FolderRepository folderRepository;

    public boolean supports(Class<?> clazz) {
        return FolderUpsetRequest.class.equals(clazz);
    }

    public void validate(Object obj, Errors errors) {
        String folderName;
        FolderUpsetRequest request = (FolderUpsetRequest)obj;
        UUID projectId = request.getProjectId();
        boolean isFolderExists = this.folderRepository.existsFolderByProjectIdAndName(projectId, folderName = request.getName());
        if (isFolderExists) {
            String errorMessage = "Folder with name " + folderName + " already exists in the database";
            log.error(errorMessage);
            folderName = folderName + " Copy";
            request.setName(folderName);
            String notificationMessage = "Set new folder name \"" + folderName + "\" for entity creation";
            log.info(notificationMessage);
        }
    }

    public FolderCreationRequestValidator(FolderRepository folderRepository) {
        this.folderRepository = folderRepository;
    }
}

