/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.dataaccess.validators;

import java.util.List;
import java.util.UUID;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.qubership.atp.itf.lite.backend.dataaccess.validators.ReferenceExists;
import org.qubership.atp.itf.lite.backend.service.IdentifiedService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class ReferenceValidator
implements ConstraintValidator<ReferenceExists, Object> {
    private final ApplicationContext applicationContext;
    public Class<? extends IdentifiedService> serviceClass;

    @Autowired
    public ReferenceValidator(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void initialize(ReferenceExists constraintAnnotation) {
        this.serviceClass = constraintAnnotation.serviceClass();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        IdentifiedService service = (IdentifiedService)this.applicationContext.getBean(this.serviceClass);
        if (value instanceof List) {
            return ((List)value).stream().allMatch(service::isEntityExists);
        }
        if (value instanceof UUID) {
            return service.isEntityExists(value);
        }
        return false;
    }
}

