/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.db.migration.v2;

import java.util.Arrays;
import java.util.UUID;
import java.util.stream.Collectors;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.qubership.atp.auth.springbootstarter.entities.ServiceEntities;
import org.qubership.atp.auth.springbootstarter.services.UsersService;
import org.qubership.atp.itf.lite.backend.configuration.SpringLiquibaseBeanAware;
import org.qubership.atp.itf.lite.backend.utils.UserManagementEntities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceEntitiesMigrationCustomChange
implements CustomTaskChange {
    private static final Logger log = LoggerFactory.getLogger(ServiceEntitiesMigrationCustomChange.class);
    private String serviceName;
    private static final UUID SERVICE_ENTITIES_ID = UUID.fromString("13f3c496-63af-4441-83bf-e2642b04bc94");

    public void execute(Database database) {
        ServiceEntities entities = new ServiceEntities();
        entities.setUuid(SERVICE_ENTITIES_ID);
        entities.setService(this.serviceName);
        entities.setEntities(Arrays.stream(UserManagementEntities.values()).map(UserManagementEntities::getName).collect(Collectors.toList()));
        UsersService usersService = SpringLiquibaseBeanAware.getBean(UsersService.class);
        log.info("Sending service entities {}", (Object)entities);
        usersService.sendEntities(entities);
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
}

