/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.ei;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import org.qubership.atp.ei.node.ImportExecutor;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.dto.ValidationResult;
import org.qubership.atp.ei.node.services.ObjectLoaderFromDiskService;
import org.qubership.atp.itf.lite.backend.ei.service.FolderImporterService;
import org.qubership.atp.itf.lite.backend.ei.service.RequestImporterService;
import org.qubership.atp.itf.lite.backend.model.entities.Folder;
import org.qubership.atp.itf.lite.backend.model.entities.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AtpItfLiteImportExecutor
implements ImportExecutor {
    private static final Logger log = LoggerFactory.getLogger(AtpItfLiteImportExecutor.class);
    private final FolderImporterService folderImporterService;
    private final RequestImporterService requestImporterService;
    private final ObjectLoaderFromDiskService objectLoaderFromDiskService;

    public void importData(ExportImportData exportImportData, Path path) throws RuntimeException {
        log.info("Start import. Data: {}, WorkDir: {}", (Object)exportImportData, (Object)path);
        this.folderImporterService.importFolders(Paths.get(path.toString(), "Folders"), exportImportData);
        this.requestImporterService.importRequests(Paths.get(path.toString(), "Requests"), exportImportData);
        this.requestImporterService.importFiles(exportImportData, path);
        log.info("End of import");
    }

    public ValidationResult preValidateData(ExportImportData exportImportData, Path path) {
        return null;
    }

    public ValidationResult validateData(ExportImportData exportImportData, Path path) {
        log.info("Start validateData. Data: {}, WorkDir: {}", (Object)exportImportData, (Object)path);
        HashMap<UUID, UUID> replacementMap = new HashMap<UUID, UUID>(exportImportData.getReplacementMap());
        replacementMap.putAll(this.requestImporterService.getReplacementMap(this.getWorkDir(path.toString(), "Requests")));
        if (exportImportData.isCreateNewProject()) {
            Set ids = this.objectLoaderFromDiskService.getListOfObjects(this.getWorkDir(path.toString(), "Folders"), Folder.class).keySet();
            ids.addAll(this.objectLoaderFromDiskService.getListOfObjects(this.getWorkDir(path.toString(), "Requests"), Request.class).keySet());
            ids.forEach(id -> replacementMap.put((UUID)id, UUID.randomUUID()));
        } else if (exportImportData.isInterProjectImport()) {
            replacementMap.putAll(this.folderImporterService.getSourceTargetMap(this.getWorkDir(path.toString(), "Folders"), replacementMap));
            replacementMap.putAll(this.requestImporterService.getSourceTargetMap(this.getWorkDir(path.toString(), "Requests"), replacementMap));
            replacementMap.entrySet().forEach(entry -> {
                if (entry.getValue() == null) {
                    entry.setValue(UUID.randomUUID());
                }
            });
        }
        replacementMap.entrySet().forEach(entry -> {
            if (entry.getValue() == null) {
                entry.setValue(UUID.randomUUID());
            }
        });
        return new ValidationResult(null, replacementMap);
    }

    private Path getWorkDir(String path, String entityType) {
        return Paths.get(path.toString(), entityType);
    }

    public AtpItfLiteImportExecutor(FolderImporterService folderImporterService, RequestImporterService requestImporterService, ObjectLoaderFromDiskService objectLoaderFromDiskService) {
        this.folderImporterService = folderImporterService;
        this.requestImporterService = requestImporterService;
        this.objectLoaderFromDiskService = objectLoaderFromDiskService;
    }
}

