/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.enums;

import java.util.concurrent.TimeUnit;

public enum CacheKeys {
    ENVIRONMENT_SYSTEMS("ATP_ITF_LITE_ENVIRONMENT_SYSTEMS", 20, TimeUnit.MINUTES, CacheGroups.SYSTEMS),
    PROJECT_CERT("ATP_ITF_LITE_PROJECT_CERT", 20, TimeUnit.MINUTES, CacheGroups.PROJECTS),
    AUTH_PROJECTS_KEY("projects", 2, TimeUnit.MINUTES, CacheGroups.PROJECTS),
    AUTH_OBJECTS_KEY("auth_objects", 2, TimeUnit.MINUTES, CacheGroups.PROJECTS);

    private final String key;
    private final int timeToLive;
    private final TimeUnit timeUnit;
    private final CacheGroups cacheGroup;

    private CacheKeys(String key, int timeToLive, TimeUnit timeUnit, CacheGroups cacheGroup) {
        this.key = key;
        this.timeToLive = timeToLive;
        this.timeUnit = timeUnit;
        this.cacheGroup = cacheGroup;
    }

    public int getTtlInSeconds() {
        switch (this.timeUnit) {
            case SECONDS: {
                return this.timeToLive;
            }
            case MINUTES: {
                return 60 * this.timeToLive;
            }
            case HOURS: {
                return 3600 * this.timeToLive;
            }
            case DAYS: {
                return 86400 * this.timeToLive;
            }
        }
        return 0;
    }

    public String getKey() {
        return this.key;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public CacheGroups getCacheGroup() {
        return this.cacheGroup;
    }

    public static enum CacheGroups {
        PROJECTS,
        SYSTEMS;

    }

    public static class Constants {
        public static final String ENVIRONMENT_SYSTEMS = "ATP_ITF_LITE_ENVIRONMENT_SYSTEMS";
        public static final String AUTH_PROJECTS_KEY = "projects";
        public static final String PROJECT_CERT = "ATP_ITF_LITE_PROJECT_CERT";
        public static final String AUTH_OBJECTS_KEY = "auth_objects";
    }
}

