/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.qubership.atp.itf.lite.backend.enums.ContextScope;
import org.springframework.util.StringUtils;

public enum ContextVariableType {
    GLOBAL("Global", ContextScope.GLOBALS),
    COLLECTION("Collection", ContextScope.COLLECTION),
    DATA("Data", ContextScope.DATA),
    ENVIRONMENT("Environment", ContextScope.ENVIRONMENT),
    LOCAL("Local", ContextScope.LOCAL_VARIABLES);

    private final String name;
    private final ContextScope contextScope;

    @JsonValue
    public String getName() {
        return this.name;
    }

    @JsonCreator
    public static ContextVariableType fromValue(String value) {
        for (ContextVariableType contextVariableType : ContextVariableType.values()) {
            if (!contextVariableType.getName().equals(value)) continue;
            return contextVariableType;
        }
        throw new IllegalArgumentException("Unknown value: " + value);
    }

    public static ContextVariableType fromContextVariableKey(String key) {
        if (!StringUtils.isEmpty((Object)key)) {
            for (ContextVariableType contextVariableType : ContextVariableType.values()) {
                String prefix = contextVariableType.getContextScope().getPrefix();
                if (StringUtils.isEmpty((Object)prefix) || !key.contains(prefix)) continue;
                return contextVariableType;
            }
        }
        return LOCAL;
    }

    private ContextVariableType(String name, ContextScope contextScope) {
        this.name = name;
        this.contextScope = contextScope;
    }

    public ContextScope getContextScope() {
        return this.contextScope;
    }
}

