/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.feign.service;

import java.util.List;
import java.util.UUID;
import org.qubership.atp.itf.lite.backend.feign.clients.EnvironmentsFeignClient;
import org.qubership.atp.itf.lite.backend.model.api.response.environments.System;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class EnvironmentFeignService {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentFeignService.class);
    private final EnvironmentsFeignClient environmentsFeignClient;

    @Cacheable(value={"ATP_ITF_LITE_ENVIRONMENT_SYSTEMS"}, key="#environmentId", condition="#environmentId != null", sync=true)
    public List<System> getEnvironmentSystems(UUID environmentId) {
        log.info("Takes actual systems from environment service");
        return this.environmentsFeignClient.getEnvironmentSystems(environmentId);
    }

    @CacheEvict(value={"ATP_ITF_LITE_ENVIRONMENT_SYSTEMS"}, key="#environmentId")
    public void evictEnvironmentSystemsCacheByEnvironmentId(UUID environmentId) {
        log.info("Environment cache for environmentId = '{}' has been evicted", (Object)environmentId);
    }

    public EnvironmentFeignService(EnvironmentsFeignClient environmentsFeignClient) {
        this.environmentsFeignClient = environmentsFeignClient;
    }
}

