/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.feign.service;

import java.util.UUID;
import org.qubership.atp.itf.lite.backend.feign.clients.ItfContextBalancerFeignClient;
import org.qubership.atp.itf.lite.backend.feign.clients.ItfVelocityBalancerFeignClient;
import org.qubership.atp.itf.lite.backend.feign.dto.ResponseObjectDto;
import org.qubership.atp.itf.lite.backend.feign.dto.UIVelocityRequestBodyDto;
import org.qubership.atp.itf.lite.backend.model.api.response.itf.ItfParametersResolveResponse;
import org.qubership.atp.itf.lite.backend.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ItfFeignService {
    private static final Logger log = LoggerFactory.getLogger(ItfFeignService.class);
    private final ItfContextBalancerFeignClient itfContextBalancerFeignClient;
    private final ItfVelocityBalancerFeignClient itfVelocityBalancerFeignClient;

    public String getContext(String contextId, UUID projectUuid) {
        return (String)this.itfContextBalancerFeignClient.get(contextId, projectUuid).getBody();
    }

    public ItfParametersResolveResponse processVelocity(UUID projectUuid, UIVelocityRequestBodyDto requestBody) {
        ResponseObjectDto responseObjectDto = (ResponseObjectDto)this.itfVelocityBalancerFeignClient.get(projectUuid, null, requestBody).getBody();
        ItfParametersResolveResponse itfParametersResolveResponse = StreamUtils.mapToClazz(responseObjectDto, ItfParametersResolveResponse.class);
        return itfParametersResolveResponse;
    }

    public ItfFeignService(ItfContextBalancerFeignClient itfContextBalancerFeignClient, ItfVelocityBalancerFeignClient itfVelocityBalancerFeignClient) {
        this.itfContextBalancerFeignClient = itfContextBalancerFeignClient;
        this.itfVelocityBalancerFeignClient = itfVelocityBalancerFeignClient;
    }
}

