/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.api.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.qubership.atp.itf.lite.backend.enums.EntityType;
import org.qubership.atp.itf.lite.backend.enums.TransportType;
import org.qubership.atp.itf.lite.backend.enums.auth.RequestAuthorizationType;
import org.qubership.atp.itf.lite.backend.model.api.request.Permissions;
import org.qubership.atp.itf.lite.backend.model.api.response.ParentRequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.Folder;
import org.qubership.atp.itf.lite.backend.model.entities.Request;
import org.qubership.atp.itf.lite.backend.model.entities.http.HttpRequest;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpMethod;

public class GroupResponse
implements Comparable<GroupResponse> {
    @NotNull
    private UUID id;
    @NotNull
    @NotEmpty
    private String name;
    private EntityType type;
    @JsonIgnore
    private Date createdWhen;
    private Date modifiedWhen;
    private Integer order;
    private List<GroupResponse> children = new ArrayList<GroupResponse>();
    @JsonIgnore
    private boolean filteredOut;
    private Permissions permissions;
    private boolean hasWritePermissions;
    @Nullable
    private RequestAuthorizationType authType;
    @Nullable
    private ParentRequestAuthorization parentAuth;
    @Nullable
    private TransportType transportType;
    @Nullable
    private HttpMethod httpMethod;

    public GroupResponse(Request request, @Nullable ParentRequestAuthorization parentAuth) {
        this(request.getId(), request.getName(), EntityType.REQUEST, request.getOrder(), request.getCreatedWhen(), parentAuth, request.getModifiedWhen());
        if (Objects.nonNull(request.getAuthorization())) {
            this.authType = request.getAuthorization().getType();
        }
        this.transportType = request.getTransportType();
        if (TransportType.REST.equals((Object)request.getTransportType()) || TransportType.SOAP.equals((Object)request.getTransportType())) {
            this.httpMethod = ((HttpRequest)request).getHttpMethod();
        }
    }

    public GroupResponse(Folder folder, @Nullable ParentRequestAuthorization parentAuth) {
        this(folder.getId(), folder.getName(), EntityType.FOLDER, folder.getOrder(), folder.getCreatedWhen(), parentAuth, folder.getModifiedWhen());
        if (Objects.nonNull(folder.getAuthorization())) {
            this.authType = folder.getAuthorization().getType();
        }
    }

    public GroupResponse(UUID id, String name, EntityType type, Integer order, Date createdWhen, @Nullable ParentRequestAuthorization parentAuth, Date modifiedWhen) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.children = new ArrayList<GroupResponse>();
        this.createdWhen = createdWhen;
        this.modifiedWhen = modifiedWhen;
        this.order = order;
        this.parentAuth = parentAuth;
    }

    public void addChildren(GroupResponse child) {
        this.children.add(child);
    }

    public void addChildren(Collection<GroupResponse> children) {
        this.children.addAll(children);
    }

    @Override
    public int compareTo(GroupResponse node) {
        int typeOrderDiff = this.type.getOrder() - node.type.getOrder();
        if (typeOrderDiff != 0) {
            return typeOrderDiff;
        }
        if (Objects.isNull(this.order) || Objects.isNull(node.order)) {
            return 0;
        }
        return this.order - node.order;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public EntityType getType() {
        return this.type;
    }

    public Date getCreatedWhen() {
        return this.createdWhen;
    }

    public Date getModifiedWhen() {
        return this.modifiedWhen;
    }

    public Integer getOrder() {
        return this.order;
    }

    public List<GroupResponse> getChildren() {
        return this.children;
    }

    public boolean isFilteredOut() {
        return this.filteredOut;
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public boolean isHasWritePermissions() {
        return this.hasWritePermissions;
    }

    @Nullable
    public RequestAuthorizationType getAuthType() {
        return this.authType;
    }

    @Nullable
    public ParentRequestAuthorization getParentAuth() {
        return this.parentAuth;
    }

    @Nullable
    public TransportType getTransportType() {
        return this.transportType;
    }

    @Nullable
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(EntityType type) {
        this.type = type;
    }

    @JsonIgnore
    public void setCreatedWhen(Date createdWhen) {
        this.createdWhen = createdWhen;
    }

    public void setModifiedWhen(Date modifiedWhen) {
        this.modifiedWhen = modifiedWhen;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public void setChildren(List<GroupResponse> children) {
        this.children = children;
    }

    @JsonIgnore
    public void setFilteredOut(boolean filteredOut) {
        this.filteredOut = filteredOut;
    }

    public void setPermissions(Permissions permissions) {
        this.permissions = permissions;
    }

    public void setHasWritePermissions(boolean hasWritePermissions) {
        this.hasWritePermissions = hasWritePermissions;
    }

    public void setAuthType(@Nullable RequestAuthorizationType authType) {
        this.authType = authType;
    }

    public void setParentAuth(@Nullable ParentRequestAuthorization parentAuth) {
        this.parentAuth = parentAuth;
    }

    public void setTransportType(@Nullable TransportType transportType) {
        this.transportType = transportType;
    }

    public void setHttpMethod(@Nullable HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupResponse)) {
            return false;
        }
        GroupResponse other = (GroupResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFilteredOut() != other.isFilteredOut()) {
            return false;
        }
        if (this.isHasWritePermissions() != other.isHasWritePermissions()) {
            return false;
        }
        Integer this$order = this.getOrder();
        Integer other$order = other.getOrder();
        if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        EntityType this$type = this.getType();
        EntityType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Date this$createdWhen = this.getCreatedWhen();
        Date other$createdWhen = other.getCreatedWhen();
        if (this$createdWhen == null ? other$createdWhen != null : !((Object)this$createdWhen).equals(other$createdWhen)) {
            return false;
        }
        Date this$modifiedWhen = this.getModifiedWhen();
        Date other$modifiedWhen = other.getModifiedWhen();
        if (this$modifiedWhen == null ? other$modifiedWhen != null : !((Object)this$modifiedWhen).equals(other$modifiedWhen)) {
            return false;
        }
        List<GroupResponse> this$children = this.getChildren();
        List<GroupResponse> other$children = other.getChildren();
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        Permissions this$permissions = this.getPermissions();
        Permissions other$permissions = other.getPermissions();
        if (this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions)) {
            return false;
        }
        RequestAuthorizationType this$authType = this.getAuthType();
        RequestAuthorizationType other$authType = other.getAuthType();
        if (this$authType == null ? other$authType != null : !((Object)((Object)this$authType)).equals((Object)other$authType)) {
            return false;
        }
        ParentRequestAuthorization this$parentAuth = this.getParentAuth();
        ParentRequestAuthorization other$parentAuth = other.getParentAuth();
        if (this$parentAuth == null ? other$parentAuth != null : !((Object)this$parentAuth).equals(other$parentAuth)) {
            return false;
        }
        TransportType this$transportType = this.getTransportType();
        TransportType other$transportType = other.getTransportType();
        if (this$transportType == null ? other$transportType != null : !((Object)((Object)this$transportType)).equals((Object)other$transportType)) {
            return false;
        }
        HttpMethod this$httpMethod = this.getHttpMethod();
        HttpMethod other$httpMethod = other.getHttpMethod();
        return !(this$httpMethod == null ? other$httpMethod != null : !((Object)((Object)this$httpMethod)).equals((Object)other$httpMethod));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GroupResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFilteredOut() ? 79 : 97);
        result = result * 59 + (this.isHasWritePermissions() ? 79 : 97);
        Integer $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        EntityType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Date $createdWhen = this.getCreatedWhen();
        result = result * 59 + ($createdWhen == null ? 43 : ((Object)$createdWhen).hashCode());
        Date $modifiedWhen = this.getModifiedWhen();
        result = result * 59 + ($modifiedWhen == null ? 43 : ((Object)$modifiedWhen).hashCode());
        List<GroupResponse> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        Permissions $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        RequestAuthorizationType $authType = this.getAuthType();
        result = result * 59 + ($authType == null ? 43 : ((Object)((Object)$authType)).hashCode());
        ParentRequestAuthorization $parentAuth = this.getParentAuth();
        result = result * 59 + ($parentAuth == null ? 43 : ((Object)$parentAuth).hashCode());
        TransportType $transportType = this.getTransportType();
        result = result * 59 + ($transportType == null ? 43 : ((Object)((Object)$transportType)).hashCode());
        HttpMethod $httpMethod = this.getHttpMethod();
        result = result * 59 + ($httpMethod == null ? 43 : ((Object)((Object)$httpMethod)).hashCode());
        return result;
    }

    public String toString() {
        return "GroupResponse(id=" + this.getId() + ", name=" + this.getName() + ", type=" + (Object)((Object)this.getType()) + ", createdWhen=" + this.getCreatedWhen() + ", modifiedWhen=" + this.getModifiedWhen() + ", order=" + this.getOrder() + ", children=" + this.getChildren() + ", filteredOut=" + this.isFilteredOut() + ", permissions=" + this.getPermissions() + ", hasWritePermissions=" + this.isHasWritePermissions() + ", authType=" + (Object)((Object)this.getAuthType()) + ", parentAuth=" + this.getParentAuth() + ", transportType=" + (Object)((Object)this.getTransportType()) + ", httpMethod=" + (Object)((Object)this.getHttpMethod()) + ")";
    }

    public GroupResponse() {
    }
}

