/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.api.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.itf.lite.backend.annotations.SerializableCheckable;
import org.qubership.atp.itf.lite.backend.enums.ContextVariableType;
import org.qubership.atp.itf.lite.backend.enums.http.RequestBodyType;
import org.qubership.atp.itf.lite.backend.feign.dto.PostmanPostmanResponseDto;
import org.qubership.atp.itf.lite.backend.model.api.dto.ResponseCookie;
import org.qubership.atp.itf.lite.backend.model.api.request.ContextVariable;
import org.qubership.atp.itf.lite.backend.model.api.request.http.HttpHeaderSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.response.ErrorResponseSerializable;
import org.qubership.atp.itf.lite.backend.model.api.response.RequestExecutionHeaderResponse;
import org.qubership.atp.itf.lite.backend.model.context.SaveRequestResolvingContext;
import org.springframework.util.CollectionUtils;

@SerializableCheckable
public class RequestExecutionResponse
implements Serializable {
    private UUID id;
    private List<RequestExecutionHeaderResponse> responseHeaders;
    private String body;
    private RequestBodyType bodyType;
    private String statusCode;
    private String statusText;
    private BigInteger duration;
    private Date startedWhen;
    private Date executedWhen;
    private String authorizationToken;
    @JsonIgnore
    private boolean testsPassed;
    private List<ContextVariable> contextVariables;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private UUID executionId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="error")
    private ErrorResponseSerializable error;
    private List<ResponseCookie> cookies;
    private HttpHeaderSaveRequest cookieHeader;

    public void updateFromPostmanResponse(PostmanPostmanResponseDto pmResponse) {
        if (Objects.nonNull(pmResponse.getHeader())) {
            this.responseHeaders = pmResponse.getHeader().stream().map(h -> new RequestExecutionHeaderResponse(h.getKey(), (String)h.getValue())).collect(Collectors.toList());
        }
        this.body = pmResponse.getBody();
        this.statusCode = String.valueOf(pmResponse.getCode());
        this.statusText = pmResponse.getStatus();
        this.duration = BigInteger.valueOf(pmResponse.getResponseTime().intValue());
    }

    public void parseAndSetContextVariables(SaveRequestResolvingContext resolvingContext) {
        if (resolvingContext != null) {
            this.parseAndSetContextVariables(resolvingContext.getGlobals(), ContextVariableType.GLOBAL);
            this.parseAndSetContextVariables(resolvingContext.getCollectionVariables(), ContextVariableType.COLLECTION);
            this.parseAndSetContextVariables(resolvingContext.getEnvironmentVariables(), ContextVariableType.ENVIRONMENT);
            this.parseAndSetContextVariables(resolvingContext.getEnvironment(), ContextVariableType.ENVIRONMENT);
            this.parseAndSetContextVariables(resolvingContext.getIterationData(), ContextVariableType.DATA);
            this.parseAndSetContextVariables(resolvingContext.getVariables(), ContextVariableType.LOCAL);
        }
    }

    private void parseAndSetContextVariables(Map<String, Object> context, ContextVariableType contextVariableType) {
        if (CollectionUtils.isEmpty(context)) {
            return;
        }
        if (this.contextVariables == null) {
            this.contextVariables = new ArrayList<ContextVariable>();
        }
        this.contextVariables.addAll(context.entrySet().stream().map(entry -> new ContextVariable((String)entry.getKey(), entry.getValue(), contextVariableType)).collect(Collectors.toList()));
    }

    public static RequestExecutionResponseBuilder builder() {
        return new RequestExecutionResponseBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public List<RequestExecutionHeaderResponse> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getBody() {
        return this.body;
    }

    public RequestBodyType getBodyType() {
        return this.bodyType;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public BigInteger getDuration() {
        return this.duration;
    }

    public Date getStartedWhen() {
        return this.startedWhen;
    }

    public Date getExecutedWhen() {
        return this.executedWhen;
    }

    public String getAuthorizationToken() {
        return this.authorizationToken;
    }

    public boolean isTestsPassed() {
        return this.testsPassed;
    }

    public List<ContextVariable> getContextVariables() {
        return this.contextVariables;
    }

    public UUID getExecutionId() {
        return this.executionId;
    }

    public ErrorResponseSerializable getError() {
        return this.error;
    }

    public List<ResponseCookie> getCookies() {
        return this.cookies;
    }

    public HttpHeaderSaveRequest getCookieHeader() {
        return this.cookieHeader;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setResponseHeaders(List<RequestExecutionHeaderResponse> responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setBodyType(RequestBodyType bodyType) {
        this.bodyType = bodyType;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public void setStatusText(String statusText) {
        this.statusText = statusText;
    }

    public void setDuration(BigInteger duration) {
        this.duration = duration;
    }

    public void setStartedWhen(Date startedWhen) {
        this.startedWhen = startedWhen;
    }

    public void setExecutedWhen(Date executedWhen) {
        this.executedWhen = executedWhen;
    }

    public void setAuthorizationToken(String authorizationToken) {
        this.authorizationToken = authorizationToken;
    }

    @JsonIgnore
    public void setTestsPassed(boolean testsPassed) {
        this.testsPassed = testsPassed;
    }

    public void setContextVariables(List<ContextVariable> contextVariables) {
        this.contextVariables = contextVariables;
    }

    public void setExecutionId(UUID executionId) {
        this.executionId = executionId;
    }

    @JsonProperty(value="error")
    public void setError(ErrorResponseSerializable error) {
        this.error = error;
    }

    public void setCookies(List<ResponseCookie> cookies) {
        this.cookies = cookies;
    }

    public void setCookieHeader(HttpHeaderSaveRequest cookieHeader) {
        this.cookieHeader = cookieHeader;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestExecutionResponse)) {
            return false;
        }
        RequestExecutionResponse other = (RequestExecutionResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isTestsPassed() != other.isTestsPassed()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        List<RequestExecutionHeaderResponse> this$responseHeaders = this.getResponseHeaders();
        List<RequestExecutionHeaderResponse> other$responseHeaders = other.getResponseHeaders();
        if (this$responseHeaders == null ? other$responseHeaders != null : !((Object)this$responseHeaders).equals(other$responseHeaders)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        RequestBodyType this$bodyType = this.getBodyType();
        RequestBodyType other$bodyType = other.getBodyType();
        if (this$bodyType == null ? other$bodyType != null : !((Object)((Object)this$bodyType)).equals((Object)other$bodyType)) {
            return false;
        }
        String this$statusCode = this.getStatusCode();
        String other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !this$statusCode.equals(other$statusCode)) {
            return false;
        }
        String this$statusText = this.getStatusText();
        String other$statusText = other.getStatusText();
        if (this$statusText == null ? other$statusText != null : !this$statusText.equals(other$statusText)) {
            return false;
        }
        BigInteger this$duration = this.getDuration();
        BigInteger other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        Date this$startedWhen = this.getStartedWhen();
        Date other$startedWhen = other.getStartedWhen();
        if (this$startedWhen == null ? other$startedWhen != null : !((Object)this$startedWhen).equals(other$startedWhen)) {
            return false;
        }
        Date this$executedWhen = this.getExecutedWhen();
        Date other$executedWhen = other.getExecutedWhen();
        if (this$executedWhen == null ? other$executedWhen != null : !((Object)this$executedWhen).equals(other$executedWhen)) {
            return false;
        }
        String this$authorizationToken = this.getAuthorizationToken();
        String other$authorizationToken = other.getAuthorizationToken();
        if (this$authorizationToken == null ? other$authorizationToken != null : !this$authorizationToken.equals(other$authorizationToken)) {
            return false;
        }
        List<ContextVariable> this$contextVariables = this.getContextVariables();
        List<ContextVariable> other$contextVariables = other.getContextVariables();
        if (this$contextVariables == null ? other$contextVariables != null : !((Object)this$contextVariables).equals(other$contextVariables)) {
            return false;
        }
        UUID this$executionId = this.getExecutionId();
        UUID other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !((Object)this$executionId).equals(other$executionId)) {
            return false;
        }
        ErrorResponseSerializable this$error = this.getError();
        ErrorResponseSerializable other$error = other.getError();
        if (this$error == null ? other$error != null : !((Object)this$error).equals(other$error)) {
            return false;
        }
        List<ResponseCookie> this$cookies = this.getCookies();
        List<ResponseCookie> other$cookies = other.getCookies();
        if (this$cookies == null ? other$cookies != null : !((Object)this$cookies).equals(other$cookies)) {
            return false;
        }
        HttpHeaderSaveRequest this$cookieHeader = this.getCookieHeader();
        HttpHeaderSaveRequest other$cookieHeader = other.getCookieHeader();
        return !(this$cookieHeader == null ? other$cookieHeader != null : !((Object)this$cookieHeader).equals(other$cookieHeader));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestExecutionResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTestsPassed() ? 79 : 97);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        List<RequestExecutionHeaderResponse> $responseHeaders = this.getResponseHeaders();
        result = result * 59 + ($responseHeaders == null ? 43 : ((Object)$responseHeaders).hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        RequestBodyType $bodyType = this.getBodyType();
        result = result * 59 + ($bodyType == null ? 43 : ((Object)((Object)$bodyType)).hashCode());
        String $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : $statusCode.hashCode());
        String $statusText = this.getStatusText();
        result = result * 59 + ($statusText == null ? 43 : $statusText.hashCode());
        BigInteger $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        Date $startedWhen = this.getStartedWhen();
        result = result * 59 + ($startedWhen == null ? 43 : ((Object)$startedWhen).hashCode());
        Date $executedWhen = this.getExecutedWhen();
        result = result * 59 + ($executedWhen == null ? 43 : ((Object)$executedWhen).hashCode());
        String $authorizationToken = this.getAuthorizationToken();
        result = result * 59 + ($authorizationToken == null ? 43 : $authorizationToken.hashCode());
        List<ContextVariable> $contextVariables = this.getContextVariables();
        result = result * 59 + ($contextVariables == null ? 43 : ((Object)$contextVariables).hashCode());
        UUID $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : ((Object)$executionId).hashCode());
        ErrorResponseSerializable $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
        List<ResponseCookie> $cookies = this.getCookies();
        result = result * 59 + ($cookies == null ? 43 : ((Object)$cookies).hashCode());
        HttpHeaderSaveRequest $cookieHeader = this.getCookieHeader();
        result = result * 59 + ($cookieHeader == null ? 43 : ((Object)$cookieHeader).hashCode());
        return result;
    }

    public String toString() {
        return "RequestExecutionResponse(id=" + this.getId() + ", responseHeaders=" + this.getResponseHeaders() + ", body=" + this.getBody() + ", bodyType=" + (Object)((Object)this.getBodyType()) + ", statusCode=" + this.getStatusCode() + ", statusText=" + this.getStatusText() + ", duration=" + this.getDuration() + ", startedWhen=" + this.getStartedWhen() + ", executedWhen=" + this.getExecutedWhen() + ", authorizationToken=" + this.getAuthorizationToken() + ", testsPassed=" + this.isTestsPassed() + ", contextVariables=" + this.getContextVariables() + ", executionId=" + this.getExecutionId() + ", error=" + this.getError() + ", cookies=" + this.getCookies() + ", cookieHeader=" + this.getCookieHeader() + ")";
    }

    public RequestExecutionResponse(UUID id, List<RequestExecutionHeaderResponse> responseHeaders, String body, RequestBodyType bodyType, String statusCode, String statusText, BigInteger duration, Date startedWhen, Date executedWhen, String authorizationToken, boolean testsPassed, List<ContextVariable> contextVariables, UUID executionId, ErrorResponseSerializable error, List<ResponseCookie> cookies, HttpHeaderSaveRequest cookieHeader) {
        this.id = id;
        this.responseHeaders = responseHeaders;
        this.body = body;
        this.bodyType = bodyType;
        this.statusCode = statusCode;
        this.statusText = statusText;
        this.duration = duration;
        this.startedWhen = startedWhen;
        this.executedWhen = executedWhen;
        this.authorizationToken = authorizationToken;
        this.testsPassed = testsPassed;
        this.contextVariables = contextVariables;
        this.executionId = executionId;
        this.error = error;
        this.cookies = cookies;
        this.cookieHeader = cookieHeader;
    }

    public RequestExecutionResponse() {
    }

    public static class RequestExecutionResponseBuilder {
        private UUID id;
        private List<RequestExecutionHeaderResponse> responseHeaders;
        private String body;
        private RequestBodyType bodyType;
        private String statusCode;
        private String statusText;
        private BigInteger duration;
        private Date startedWhen;
        private Date executedWhen;
        private String authorizationToken;
        private boolean testsPassed;
        private List<ContextVariable> contextVariables;
        private UUID executionId;
        private ErrorResponseSerializable error;
        private List<ResponseCookie> cookies;
        private HttpHeaderSaveRequest cookieHeader;

        RequestExecutionResponseBuilder() {
        }

        public RequestExecutionResponseBuilder id(UUID id) {
            this.id = id;
            return this;
        }

        public RequestExecutionResponseBuilder responseHeaders(List<RequestExecutionHeaderResponse> responseHeaders) {
            this.responseHeaders = responseHeaders;
            return this;
        }

        public RequestExecutionResponseBuilder body(String body) {
            this.body = body;
            return this;
        }

        public RequestExecutionResponseBuilder bodyType(RequestBodyType bodyType) {
            this.bodyType = bodyType;
            return this;
        }

        public RequestExecutionResponseBuilder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public RequestExecutionResponseBuilder statusText(String statusText) {
            this.statusText = statusText;
            return this;
        }

        public RequestExecutionResponseBuilder duration(BigInteger duration) {
            this.duration = duration;
            return this;
        }

        public RequestExecutionResponseBuilder startedWhen(Date startedWhen) {
            this.startedWhen = startedWhen;
            return this;
        }

        public RequestExecutionResponseBuilder executedWhen(Date executedWhen) {
            this.executedWhen = executedWhen;
            return this;
        }

        public RequestExecutionResponseBuilder authorizationToken(String authorizationToken) {
            this.authorizationToken = authorizationToken;
            return this;
        }

        @JsonIgnore
        public RequestExecutionResponseBuilder testsPassed(boolean testsPassed) {
            this.testsPassed = testsPassed;
            return this;
        }

        public RequestExecutionResponseBuilder contextVariables(List<ContextVariable> contextVariables) {
            this.contextVariables = contextVariables;
            return this;
        }

        public RequestExecutionResponseBuilder executionId(UUID executionId) {
            this.executionId = executionId;
            return this;
        }

        @JsonProperty(value="error")
        public RequestExecutionResponseBuilder error(ErrorResponseSerializable error) {
            this.error = error;
            return this;
        }

        public RequestExecutionResponseBuilder cookies(List<ResponseCookie> cookies) {
            this.cookies = cookies;
            return this;
        }

        public RequestExecutionResponseBuilder cookieHeader(HttpHeaderSaveRequest cookieHeader) {
            this.cookieHeader = cookieHeader;
            return this;
        }

        public RequestExecutionResponse build() {
            return new RequestExecutionResponse(this.id, this.responseHeaders, this.body, this.bodyType, this.statusCode, this.statusText, this.duration, this.startedWhen, this.executedWhen, this.authorizationToken, this.testsPassed, this.contextVariables, this.executionId, this.error, this.cookies, this.cookieHeader);
        }

        public String toString() {
            return "RequestExecutionResponse.RequestExecutionResponseBuilder(id=" + this.id + ", responseHeaders=" + this.responseHeaders + ", body=" + this.body + ", bodyType=" + (Object)((Object)this.bodyType) + ", statusCode=" + this.statusCode + ", statusText=" + this.statusText + ", duration=" + this.duration + ", startedWhen=" + this.startedWhen + ", executedWhen=" + this.executedWhen + ", authorizationToken=" + this.authorizationToken + ", testsPassed=" + this.testsPassed + ", contextVariables=" + this.contextVariables + ", executionId=" + this.executionId + ", error=" + this.error + ", cookies=" + this.cookies + ", cookieHeader=" + this.cookieHeader + ")";
        }
    }
}

