/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.ei;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.qubership.atp.itf.lite.backend.model.ei.ToPostmanAuthType;
import org.qubership.atp.itf.lite.backend.model.ei.ToPostmanMapType;
import org.qubership.atp.itf.lite.backend.model.entities.auth.BasicRequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.BearerRequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.OAuth2RequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.RequestAuthorization;

public class ToPostmanAuth {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private ToPostmanAuthType type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<ToPostmanMapType> bearer;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<ToPostmanMapType> oauth2;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<ToPostmanMapType> basic;

    public ToPostmanAuth(@Nullable RequestAuthorization requestAuthorization) {
        if (Objects.nonNull(requestAuthorization)) {
            switch (requestAuthorization.getType()) {
                case OAUTH2: {
                    this.type = ToPostmanAuthType.OAUTH2;
                    OAuth2RequestAuthorization auth = (OAuth2RequestAuthorization)requestAuthorization;
                    this.oauth2 = Arrays.asList(ToPostmanMapType.addTokenToHeader(), ToPostmanMapType.headerPrefix(auth.getHeaderPrefix()), ToPostmanMapType.grantType(auth.getGrantType().getKey()), ToPostmanMapType.authUrl(auth.getAuthUrl()), ToPostmanMapType.accessTokenUrl(auth.getUrl()), ToPostmanMapType.clientId(auth.getClientId()), ToPostmanMapType.userName(auth.getUsername()), ToPostmanMapType.scope(auth.getScope()), ToPostmanMapType.state(auth.getState()));
                    break;
                }
                case BEARER: {
                    this.type = ToPostmanAuthType.BEARER;
                    this.bearer = Arrays.asList(ToPostmanMapType.token(((BearerRequestAuthorization)requestAuthorization).getToken()));
                    break;
                }
                case BASIC: {
                    this.type = ToPostmanAuthType.BASIC;
                    BasicRequestAuthorization basicAuth = (BasicRequestAuthorization)requestAuthorization;
                    this.basic = Arrays.asList(ToPostmanMapType.userName(basicAuth.getUsername()));
                    break;
                }
            }
        } else {
            this.type = ToPostmanAuthType.NOAUTH;
        }
    }

    public ToPostmanAuthType getType() {
        return this.type;
    }

    public List<ToPostmanMapType> getBearer() {
        return this.bearer;
    }

    public List<ToPostmanMapType> getOauth2() {
        return this.oauth2;
    }

    public List<ToPostmanMapType> getBasic() {
        return this.basic;
    }
}

