/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.ei;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.itf.lite.backend.model.ei.ToPostmanEvent;
import org.qubership.atp.itf.lite.backend.model.ei.ToPostmanRequest;
import org.qubership.atp.itf.lite.backend.model.entities.Folder;
import org.qubership.atp.itf.lite.backend.model.entities.http.HttpRequest;

public class ToPostmanItem {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private UUID id;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String description;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<ToPostmanEvent> event;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private ToPostmanRequest request;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<String> response;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<ToPostmanItem> item;

    public ToPostmanItem(HttpRequest request) {
        this.id = request.getId();
        this.name = request.getName();
        this.description = request.getName();
        if (!Strings.isNullOrEmpty((String)request.getPreScripts())) {
            if (this.event == null) {
                this.event = new ArrayList<ToPostmanEvent>();
            }
            this.event.add(ToPostmanEvent.prerequest(request.getPreScripts()));
        }
        if (!Strings.isNullOrEmpty((String)request.getPostScripts())) {
            if (this.event == null) {
                this.event = new ArrayList<ToPostmanEvent>();
            }
            this.event.add(ToPostmanEvent.test(request.getPostScripts()));
        }
        this.request = new ToPostmanRequest(request);
        this.response = new ArrayList<String>();
    }

    public ToPostmanItem(Folder folder) {
        this.id = folder.getId();
        this.name = folder.getName();
    }

    @JsonIgnore
    public List<ToPostmanItem> getItems() {
        if (this.item == null) {
            this.item = new ArrayList<ToPostmanItem>();
        }
        return this.item;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<ToPostmanEvent> getEvent() {
        return this.event;
    }

    public ToPostmanRequest getRequest() {
        return this.request;
    }

    public List<String> getResponse() {
        return this.response;
    }

    public List<ToPostmanItem> getItem() {
        return this.item;
    }
}

