/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.javers.core.metamodel.annotation.DiffInclude;
import org.qubership.atp.itf.lite.backend.model.entities.AbstractNamedEntity;
import org.qubership.atp.itf.lite.backend.model.entities.auth.RequestAuthorization;

@Entity
@Table(name="folders")
public class Folder
extends AbstractNamedEntity {
    @Column(name="project_id")
    @DiffInclude
    private UUID projectId;
    @Column(name="parent_id")
    @DiffInclude
    private UUID parentId;
    @Column(name="`order`")
    @DiffInclude
    private Integer order;
    @Column(name="source_id")
    @DiffInclude
    private UUID sourceId;
    @Column(name="permission_folder_id")
    @DiffInclude
    private UUID permissionFolderId;
    @Column(name="disable_cookie_generation")
    @DiffInclude
    private boolean isAutoCookieDisabled;
    @Column(name="disable_ssl_certificate_verification")
    @DiffInclude
    private boolean disableSslCertificateVerification;
    @Column(name="disable_ssl_client_certificate")
    @DiffInclude
    private boolean disableSslClientCertificate;
    @Column(name="disable_following_redirect")
    @DiffInclude
    private boolean disableFollowingRedirect;
    @Column(name="disable_auto_encoding")
    @DiffInclude
    private boolean disableAutoEncoding;
    @Column(name="description", columnDefinition="TEXT")
    @DiffInclude
    private String description;
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="authorization_id")
    @DiffInclude
    protected RequestAuthorization authorization;
    @Column(name="permission_info")
    @DiffInclude
    private String permission;
    @Column(name="child_folders")
    @DiffInclude
    private String childFolders;
    @Column(name="child_requests")
    @DiffInclude
    private String childRequests;

    public Folder(Folder folder) {
        this.id = folder.getId();
        this.name = folder.getName();
        this.projectId = folder.getProjectId();
        this.parentId = folder.getParentId();
        this.order = folder.getOrder();
        this.sourceId = folder.getSourceId();
        this.permissionFolderId = folder.getPermissionFolderId();
        this.isAutoCookieDisabled = folder.isAutoCookieDisabled();
        this.disableSslCertificateVerification = folder.isDisableSslCertificateVerification();
        this.disableSslClientCertificate = folder.isDisableSslClientCertificate();
        this.disableFollowingRedirect = folder.isDisableFollowingRedirect();
        this.description = folder.getDescription();
        RequestAuthorization authorization = folder.getAuthorization();
        if (Objects.nonNull(authorization)) {
            this.authorization = authorization.copy();
        }
        this.permission = folder.getPermission();
        this.childFolders = folder.getChildFolders();
        this.childRequests = folder.getChildRequests();
    }

    @JsonProperty(value="isAutoCookieDisabled")
    public boolean isAutoCookieDisabled() {
        return this.isAutoCookieDisabled;
    }

    public void setAutoCookieDisabled(boolean isAutoCookieDisabled) {
        this.isAutoCookieDisabled = isAutoCookieDisabled;
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public UUID getParentId() {
        return this.parentId;
    }

    public Integer getOrder() {
        return this.order;
    }

    public UUID getSourceId() {
        return this.sourceId;
    }

    public UUID getPermissionFolderId() {
        return this.permissionFolderId;
    }

    public boolean isDisableSslCertificateVerification() {
        return this.disableSslCertificateVerification;
    }

    public boolean isDisableSslClientCertificate() {
        return this.disableSslClientCertificate;
    }

    public boolean isDisableFollowingRedirect() {
        return this.disableFollowingRedirect;
    }

    public boolean isDisableAutoEncoding() {
        return this.disableAutoEncoding;
    }

    public String getDescription() {
        return this.description;
    }

    public RequestAuthorization getAuthorization() {
        return this.authorization;
    }

    public String getPermission() {
        return this.permission;
    }

    public String getChildFolders() {
        return this.childFolders;
    }

    public String getChildRequests() {
        return this.childRequests;
    }

    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    public void setParentId(UUID parentId) {
        this.parentId = parentId;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public void setSourceId(UUID sourceId) {
        this.sourceId = sourceId;
    }

    public void setPermissionFolderId(UUID permissionFolderId) {
        this.permissionFolderId = permissionFolderId;
    }

    public void setDisableSslCertificateVerification(boolean disableSslCertificateVerification) {
        this.disableSslCertificateVerification = disableSslCertificateVerification;
    }

    public void setDisableSslClientCertificate(boolean disableSslClientCertificate) {
        this.disableSslClientCertificate = disableSslClientCertificate;
    }

    public void setDisableFollowingRedirect(boolean disableFollowingRedirect) {
        this.disableFollowingRedirect = disableFollowingRedirect;
    }

    public void setDisableAutoEncoding(boolean disableAutoEncoding) {
        this.disableAutoEncoding = disableAutoEncoding;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAuthorization(RequestAuthorization authorization) {
        this.authorization = authorization;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public void setChildFolders(String childFolders) {
        this.childFolders = childFolders;
    }

    public void setChildRequests(String childRequests) {
        this.childRequests = childRequests;
    }

    @Override
    public String toString() {
        return "Folder(projectId=" + this.getProjectId() + ", parentId=" + this.getParentId() + ", order=" + this.getOrder() + ", sourceId=" + this.getSourceId() + ", permissionFolderId=" + this.getPermissionFolderId() + ", isAutoCookieDisabled=" + this.isAutoCookieDisabled() + ", disableSslCertificateVerification=" + this.isDisableSslCertificateVerification() + ", disableSslClientCertificate=" + this.isDisableSslClientCertificate() + ", disableFollowingRedirect=" + this.isDisableFollowingRedirect() + ", disableAutoEncoding=" + this.isDisableAutoEncoding() + ", description=" + this.getDescription() + ", authorization=" + this.getAuthorization() + ", permission=" + this.getPermission() + ", childFolders=" + this.getChildFolders() + ", childRequests=" + this.getChildRequests() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Folder)) {
            return false;
        }
        Folder other = (Folder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isAutoCookieDisabled() != other.isAutoCookieDisabled()) {
            return false;
        }
        if (this.isDisableSslCertificateVerification() != other.isDisableSslCertificateVerification()) {
            return false;
        }
        if (this.isDisableSslClientCertificate() != other.isDisableSslClientCertificate()) {
            return false;
        }
        if (this.isDisableFollowingRedirect() != other.isDisableFollowingRedirect()) {
            return false;
        }
        if (this.isDisableAutoEncoding() != other.isDisableAutoEncoding()) {
            return false;
        }
        Integer this$order = this.getOrder();
        Integer other$order = other.getOrder();
        if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
            return false;
        }
        UUID this$projectId = this.getProjectId();
        UUID other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        UUID this$parentId = this.getParentId();
        UUID other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !((Object)this$parentId).equals(other$parentId)) {
            return false;
        }
        UUID this$sourceId = this.getSourceId();
        UUID other$sourceId = other.getSourceId();
        if (this$sourceId == null ? other$sourceId != null : !((Object)this$sourceId).equals(other$sourceId)) {
            return false;
        }
        UUID this$permissionFolderId = this.getPermissionFolderId();
        UUID other$permissionFolderId = other.getPermissionFolderId();
        if (this$permissionFolderId == null ? other$permissionFolderId != null : !((Object)this$permissionFolderId).equals(other$permissionFolderId)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        RequestAuthorization this$authorization = this.getAuthorization();
        RequestAuthorization other$authorization = other.getAuthorization();
        if (this$authorization == null ? other$authorization != null : !((Object)this$authorization).equals(other$authorization)) {
            return false;
        }
        String this$permission = this.getPermission();
        String other$permission = other.getPermission();
        if (this$permission == null ? other$permission != null : !this$permission.equals(other$permission)) {
            return false;
        }
        String this$childFolders = this.getChildFolders();
        String other$childFolders = other.getChildFolders();
        if (this$childFolders == null ? other$childFolders != null : !this$childFolders.equals(other$childFolders)) {
            return false;
        }
        String this$childRequests = this.getChildRequests();
        String other$childRequests = other.getChildRequests();
        return !(this$childRequests == null ? other$childRequests != null : !this$childRequests.equals(other$childRequests));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Folder;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isAutoCookieDisabled() ? 79 : 97);
        result = result * 59 + (this.isDisableSslCertificateVerification() ? 79 : 97);
        result = result * 59 + (this.isDisableSslClientCertificate() ? 79 : 97);
        result = result * 59 + (this.isDisableFollowingRedirect() ? 79 : 97);
        result = result * 59 + (this.isDisableAutoEncoding() ? 79 : 97);
        Integer $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
        UUID $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        UUID $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : ((Object)$parentId).hashCode());
        UUID $sourceId = this.getSourceId();
        result = result * 59 + ($sourceId == null ? 43 : ((Object)$sourceId).hashCode());
        UUID $permissionFolderId = this.getPermissionFolderId();
        result = result * 59 + ($permissionFolderId == null ? 43 : ((Object)$permissionFolderId).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        RequestAuthorization $authorization = this.getAuthorization();
        result = result * 59 + ($authorization == null ? 43 : ((Object)$authorization).hashCode());
        String $permission = this.getPermission();
        result = result * 59 + ($permission == null ? 43 : $permission.hashCode());
        String $childFolders = this.getChildFolders();
        result = result * 59 + ($childFolders == null ? 43 : $childFolders.hashCode());
        String $childRequests = this.getChildRequests();
        result = result * 59 + ($childRequests == null ? 43 : $childRequests.hashCode());
        return result;
    }

    public Folder() {
    }
}

