/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.entities.auth;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import org.javers.core.metamodel.annotation.DiffInclude;
import org.qubership.atp.itf.lite.backend.enums.auth.OAuth1AddDataType;
import org.qubership.atp.itf.lite.backend.enums.auth.OAuth1SignatureMethod;
import org.qubership.atp.itf.lite.backend.model.entities.auth.RequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpMethod;

@Entity
@Table(name="oauth1_request_authorizations")
public class OAuth1RequestAuthorization
extends RequestAuthorization {
    @Column(name="url")
    @DiffInclude
    private String url;
    @Enumerated(value=EnumType.STRING)
    @Column(name="http_method")
    @DiffInclude
    private HttpMethod httpMethod;
    @Enumerated(value=EnumType.STRING)
    @Column(name="add_data_type", nullable=false)
    @DiffInclude
    private OAuth1AddDataType addDataType;
    @Column(name="signature_method", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @DiffInclude
    private OAuth1SignatureMethod signatureMethod;
    @Column(name="consumer_key", nullable=false)
    @DiffInclude
    private String consumerKey;
    @Column(name="consumer_secret", nullable=false)
    @DiffInclude
    private String consumerSecret;
    @Column(name="access_token")
    @DiffInclude
    private String accessToken;
    @Column(name="token_secret")
    @DiffInclude
    private String tokenSecret;

    public OAuth1RequestAuthorization(OAuth1RequestAuthorization authorization) {
        super(authorization);
        this.signatureMethod = authorization.getSignatureMethod();
        this.consumerKey = authorization.getConsumerKey();
        this.consumerSecret = authorization.getConsumerSecret();
        this.accessToken = authorization.getAccessToken();
        this.tokenSecret = authorization.getTokenSecret();
    }

    @Override
    public OAuth1RequestAuthorization copy() {
        return new OAuth1RequestAuthorization(this);
    }

    public String getUrl() {
        return this.url;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public OAuth1AddDataType getAddDataType() {
        return this.addDataType;
    }

    public OAuth1SignatureMethod getSignatureMethod() {
        return this.signatureMethod;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setAddDataType(OAuth1AddDataType addDataType) {
        this.addDataType = addDataType;
    }

    public void setSignatureMethod(OAuth1SignatureMethod signatureMethod) {
        this.signatureMethod = signatureMethod;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setTokenSecret(String tokenSecret) {
        this.tokenSecret = tokenSecret;
    }

    @Override
    public String toString() {
        return "OAuth1RequestAuthorization(url=" + this.getUrl() + ", httpMethod=" + (Object)((Object)this.getHttpMethod()) + ", addDataType=" + (Object)((Object)this.getAddDataType()) + ", signatureMethod=" + (Object)((Object)this.getSignatureMethod()) + ", consumerKey=" + this.getConsumerKey() + ", consumerSecret=" + this.getConsumerSecret() + ", accessToken=" + this.getAccessToken() + ", tokenSecret=" + this.getTokenSecret() + ")";
    }

    public OAuth1RequestAuthorization() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth1RequestAuthorization)) {
            return false;
        }
        OAuth1RequestAuthorization other = (OAuth1RequestAuthorization)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        HttpMethod this$httpMethod = this.getHttpMethod();
        HttpMethod other$httpMethod = other.getHttpMethod();
        if (this$httpMethod == null ? other$httpMethod != null : !((Object)((Object)this$httpMethod)).equals((Object)other$httpMethod)) {
            return false;
        }
        OAuth1AddDataType this$addDataType = this.getAddDataType();
        OAuth1AddDataType other$addDataType = other.getAddDataType();
        if (this$addDataType == null ? other$addDataType != null : !((Object)((Object)this$addDataType)).equals((Object)other$addDataType)) {
            return false;
        }
        OAuth1SignatureMethod this$signatureMethod = this.getSignatureMethod();
        OAuth1SignatureMethod other$signatureMethod = other.getSignatureMethod();
        if (this$signatureMethod == null ? other$signatureMethod != null : !((Object)((Object)this$signatureMethod)).equals((Object)other$signatureMethod)) {
            return false;
        }
        String this$consumerKey = this.getConsumerKey();
        String other$consumerKey = other.getConsumerKey();
        if (this$consumerKey == null ? other$consumerKey != null : !this$consumerKey.equals(other$consumerKey)) {
            return false;
        }
        String this$consumerSecret = this.getConsumerSecret();
        String other$consumerSecret = other.getConsumerSecret();
        if (this$consumerSecret == null ? other$consumerSecret != null : !this$consumerSecret.equals(other$consumerSecret)) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        String this$tokenSecret = this.getTokenSecret();
        String other$tokenSecret = other.getTokenSecret();
        return !(this$tokenSecret == null ? other$tokenSecret != null : !this$tokenSecret.equals(other$tokenSecret));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OAuth1RequestAuthorization;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        HttpMethod $httpMethod = this.getHttpMethod();
        result = result * 59 + ($httpMethod == null ? 43 : ((Object)((Object)$httpMethod)).hashCode());
        OAuth1AddDataType $addDataType = this.getAddDataType();
        result = result * 59 + ($addDataType == null ? 43 : ((Object)((Object)$addDataType)).hashCode());
        OAuth1SignatureMethod $signatureMethod = this.getSignatureMethod();
        result = result * 59 + ($signatureMethod == null ? 43 : ((Object)((Object)$signatureMethod)).hashCode());
        String $consumerKey = this.getConsumerKey();
        result = result * 59 + ($consumerKey == null ? 43 : $consumerKey.hashCode());
        String $consumerSecret = this.getConsumerSecret();
        result = result * 59 + ($consumerSecret == null ? 43 : $consumerSecret.hashCode());
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        String $tokenSecret = this.getTokenSecret();
        result = result * 59 + ($tokenSecret == null ? 43 : $tokenSecret.hashCode());
        return result;
    }
}

