/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.entities.converters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.apache.logging.log4j.util.Strings;
import org.qubership.atp.itf.lite.backend.exceptions.ItfLiteException;
import org.qubership.atp.itf.lite.backend.model.api.response.ErrorResponseSerializable;
import org.qubership.atp.itf.lite.backend.utils.RequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Converter
@Component
public class ErrorResponseSerializableConverter
implements AttributeConverter<ErrorResponseSerializable, String> {
    private static final Logger log = LoggerFactory.getLogger(ErrorResponseSerializableConverter.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public String convertToDatabaseColumn(ErrorResponseSerializable errorMessage) {
        String errorMessageJson = null;
        if (errorMessage != null) {
            try {
                errorMessageJson = objectMapper.writeValueAsString((Object)errorMessage);
            }
            catch (JsonProcessingException e) {
                log.error("JSON writing error", (Throwable)e);
            }
        }
        return errorMessageJson;
    }

    public ErrorResponseSerializable convertToEntityAttribute(String errorMessageString) {
        if (Strings.isNotBlank((String)errorMessageString)) {
            try {
                return (ErrorResponseSerializable)objectMapper.readValue(errorMessageString, ErrorResponseSerializable.class);
            }
            catch (IOException e) {
                return RequestUtils.getErrorResponse((Exception)((Object)new ItfLiteException(errorMessageString)));
            }
        }
        return null;
    }
}

