/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.entities.converters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.apache.logging.log4j.util.Strings;
import org.qubership.atp.itf.lite.backend.model.api.request.http.HttpHeaderSaveRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Converter
@Component
public class HttpHeaderSaveRequestConverter
implements AttributeConverter<HttpHeaderSaveRequest, String> {
    private static final Logger log = LoggerFactory.getLogger(HttpHeaderSaveRequestConverter.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public String convertToDatabaseColumn(HttpHeaderSaveRequest httpHeaderSaveRequest) {
        String errorMessageJson = null;
        if (httpHeaderSaveRequest != null) {
            try {
                errorMessageJson = objectMapper.writeValueAsString((Object)httpHeaderSaveRequest);
            }
            catch (JsonProcessingException e) {
                log.error("JSON writing error", (Throwable)e);
            }
        }
        return errorMessageJson;
    }

    public HttpHeaderSaveRequest convertToEntityAttribute(String httpHeaderSaveRequest) {
        if (Strings.isNotBlank((String)httpHeaderSaveRequest)) {
            try {
                return (HttpHeaderSaveRequest)objectMapper.readValue(httpHeaderSaveRequest, HttpHeaderSaveRequest.class);
            }
            catch (IOException e) {
                log.error("JSON writing error", (Throwable)e);
            }
        }
        return null;
    }
}

