/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.entities.converters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.qubership.atp.itf.lite.backend.enums.RequestExportStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Converter
@Component
public class RequestExportHashMapConverter
implements AttributeConverter<Map<UUID, RequestExportStatus>, String> {
    private static final Logger log = LoggerFactory.getLogger(RequestExportHashMapConverter.class);

    public String convertToDatabaseColumn(Map<UUID, RequestExportStatus> requestStatuses) {
        String requestStatusesJson = null;
        try {
            requestStatusesJson = new ObjectMapper().writeValueAsString(requestStatuses);
        }
        catch (JsonProcessingException e) {
            log.error("JSON writing error", (Throwable)e);
        }
        return requestStatusesJson;
    }

    public Map<UUID, RequestExportStatus> convertToEntityAttribute(String requestStatusesJson) {
        Map requestStatuses = null;
        try {
            requestStatuses = (Map)new ObjectMapper().readValue(requestStatusesJson, (TypeReference)new TypeReference<Map<UUID, RequestExportStatus>>(){});
        }
        catch (IOException e) {
            log.error("JSON reading error", (Throwable)e);
        }
        return requestStatuses;
    }
}

