/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.entities.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.qubership.atp.itf.lite.backend.model.api.request.HttpRequestEntitySaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.http.HttpHeaderSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.response.RequestExecutionHeaderResponse;
import org.qubership.atp.itf.lite.backend.model.api.response.RequestExecutionResponse;
import org.qubership.atp.itf.lite.backend.model.entities.converters.HashMapConverter;
import org.qubership.atp.itf.lite.backend.model.entities.history.HistoryRequestBody;
import org.qubership.atp.itf.lite.backend.model.entities.history.RequestExecution;
import org.qubership.atp.itf.lite.backend.model.entities.history.RequestExecutionDetails;

@Entity
@Table(name="http_request_execution_details")
public class HttpRequestExecutionDetails
extends RequestExecutionDetails {
    @Column(name="request_headers", columnDefinition="TEXT")
    @Convert(converter=HashMapConverter.class)
    private Map<String, List<String>> requestHeaders;
    @Column(name="response_headers", columnDefinition="TEXT")
    @Convert(converter=HashMapConverter.class)
    private Map<String, List<String>> responseHeaders;

    public HttpRequestExecutionDetails(RequestExecution requestExecution, HttpRequestEntitySaveRequest request, RequestExecutionResponse response, Exception errorMessage, HistoryRequestBody requestBody) {
        this.update(requestExecution, request, response, errorMessage, requestBody);
    }

    public void update(RequestExecution requestExecution, HttpRequestEntitySaveRequest request, RequestExecutionResponse response, Exception errorMessage, HistoryRequestBody requestBody) {
        super.update(requestExecution, request, response, errorMessage, requestBody);
        this.requestHeaders = this.collectRequestHeaders(request.getRequestHeaders());
        if (response != null) {
            this.responseHeaders = this.collectResponseHeaders(response.getResponseHeaders());
        }
    }

    private Map<String, List<String>> collectResponseHeaders(List<RequestExecutionHeaderResponse> responseHeaders) {
        HashMap<String, List<String>> headersOrigin = new HashMap<String, List<String>>();
        if (Objects.nonNull(responseHeaders)) {
            responseHeaders.forEach(header -> {
                List<String> values;
                String key = header.getKey();
                if (Objects.nonNull(headersOrigin.get(key))) {
                    values = (List)headersOrigin.get(key);
                    values.add(header.getValue());
                } else {
                    values = new ArrayList();
                    values.add(header.getValue());
                }
                headersOrigin.put(key, values);
            });
        }
        return headersOrigin;
    }

    private Map<String, List<String>> collectRequestHeaders(List<HttpHeaderSaveRequest> requestHeaders) {
        HashMap<String, List<String>> headersOrigin = new HashMap<String, List<String>>();
        requestHeaders.stream().filter(header -> !header.isDisabled()).forEach(header -> headersOrigin.put(header.getKey(), Collections.singletonList(header.getValue())));
        return headersOrigin;
    }

    public Map<String, List<String>> getRequestHeaders() {
        return this.requestHeaders;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setRequestHeaders(Map<String, List<String>> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public void setResponseHeaders(Map<String, List<String>> responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    @Override
    public String toString() {
        return "HttpRequestExecutionDetails(requestHeaders=" + this.getRequestHeaders() + ", responseHeaders=" + this.getResponseHeaders() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequestExecutionDetails)) {
            return false;
        }
        HttpRequestExecutionDetails other = (HttpRequestExecutionDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, List<String>> this$requestHeaders = this.getRequestHeaders();
        Map<String, List<String>> other$requestHeaders = other.getRequestHeaders();
        if (this$requestHeaders == null ? other$requestHeaders != null : !((Object)this$requestHeaders).equals(other$requestHeaders)) {
            return false;
        }
        Map<String, List<String>> this$responseHeaders = this.getResponseHeaders();
        Map<String, List<String>> other$responseHeaders = other.getResponseHeaders();
        return !(this$responseHeaders == null ? other$responseHeaders != null : !((Object)this$responseHeaders).equals(other$responseHeaders));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HttpRequestExecutionDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, List<String>> $requestHeaders = this.getRequestHeaders();
        result = result * 59 + ($requestHeaders == null ? 43 : ((Object)$requestHeaders).hashCode());
        Map<String, List<String>> $responseHeaders = this.getResponseHeaders();
        result = result * 59 + ($responseHeaders == null ? 43 : ((Object)$responseHeaders).hashCode());
        return result;
    }

    public HttpRequestExecutionDetails() {
    }
}

