/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.entities.history;

import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import org.qubership.atp.itf.lite.backend.enums.TestingStatus;
import org.qubership.atp.itf.lite.backend.enums.TransportType;
import org.qubership.atp.itf.lite.backend.model.api.request.HttpRequestEntitySaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestEntitySaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.http.HttpParamSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.response.RequestExecutionResponse;
import org.qubership.atp.itf.lite.backend.model.entities.AbstractEntity;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpMethod;
import org.springframework.util.CollectionUtils;

@Entity
@Table(name="request_executions")
@Inheritance(strategy=InheritanceType.JOINED)
public class RequestExecution
extends AbstractEntity {
    @Column(name="url")
    private String url;
    @Column(name="name")
    private String name;
    @Column(name="project_id")
    private UUID projectId;
    @Enumerated(value=EnumType.STRING)
    @Column(name="transport_type")
    private TransportType transportType;
    @Column(name="executed_when")
    private Date executedWhen;
    @Column(name="executor")
    private String executor;
    @Column(name="status_code")
    private String statusCode;
    @Column(name="status_text")
    private String statusText;
    @Column(name="duration")
    private BigInteger duration;
    @Column(name="sse_id")
    private UUID sseId;
    @Column(name="authorization_token", columnDefinition="TEXT")
    private String authorizationToken;
    @Column(name="testing_status")
    @Enumerated(value=EnumType.STRING)
    private TestingStatus testingStatus;

    public RequestExecution(String executor, UUID sseId, RequestEntitySaveRequest request, RequestExecutionResponse response, TestingStatus testingStatus) {
        this.executor = executor;
        this.sseId = sseId;
        this.update(request, response, testingStatus);
    }

    public void update(RequestEntitySaveRequest request, RequestExecutionResponse response, TestingStatus testingStatus) {
        this.url = this.collectUrl((HttpRequestEntitySaveRequest)request);
        this.name = request.getName();
        this.projectId = request.getProjectId();
        this.transportType = request.getTransportType();
        if (Objects.nonNull(response)) {
            this.executedWhen = response.getExecutedWhen();
            this.statusCode = response.getStatusCode();
            this.statusText = response.getStatusText();
            this.duration = response.getDuration();
            this.authorizationToken = response.getAuthorizationToken();
        }
        if (Objects.isNull(this.executedWhen)) {
            this.executedWhen = new Date();
        }
        this.testingStatus = testingStatus;
    }

    public void update(RequestEntitySaveRequest request, RequestExecutionResponse response) {
        this.update(request, response, this.testingStatus);
    }

    private String collectUrl(HttpRequestEntitySaveRequest request) {
        HttpMethod httpMethod = request.getHttpMethod();
        String url = request.getUrl();
        List<HttpParamSaveRequest> requestParams = request.getRequestParams();
        StringBuilder builder = new StringBuilder().append(httpMethod.name()).append(" ").append(url);
        if (!CollectionUtils.isEmpty(requestParams)) {
            String params = requestParams.stream().filter(param -> !param.isDisabled()).map(param -> param.getKey() + "=" + param.getValue()).collect(Collectors.joining("&", "?", ""));
            builder.append(params);
        }
        return builder.toString();
    }

    public String getUrl() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public TransportType getTransportType() {
        return this.transportType;
    }

    public Date getExecutedWhen() {
        return this.executedWhen;
    }

    public String getExecutor() {
        return this.executor;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public BigInteger getDuration() {
        return this.duration;
    }

    public UUID getSseId() {
        return this.sseId;
    }

    public String getAuthorizationToken() {
        return this.authorizationToken;
    }

    public TestingStatus getTestingStatus() {
        return this.testingStatus;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    public void setTransportType(TransportType transportType) {
        this.transportType = transportType;
    }

    public void setExecutedWhen(Date executedWhen) {
        this.executedWhen = executedWhen;
    }

    public void setExecutor(String executor) {
        this.executor = executor;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public void setStatusText(String statusText) {
        this.statusText = statusText;
    }

    public void setDuration(BigInteger duration) {
        this.duration = duration;
    }

    public void setSseId(UUID sseId) {
        this.sseId = sseId;
    }

    public void setAuthorizationToken(String authorizationToken) {
        this.authorizationToken = authorizationToken;
    }

    public void setTestingStatus(TestingStatus testingStatus) {
        this.testingStatus = testingStatus;
    }

    @Override
    public String toString() {
        return "RequestExecution(url=" + this.getUrl() + ", name=" + this.getName() + ", projectId=" + this.getProjectId() + ", transportType=" + (Object)((Object)this.getTransportType()) + ", executedWhen=" + this.getExecutedWhen() + ", executor=" + this.getExecutor() + ", statusCode=" + this.getStatusCode() + ", statusText=" + this.getStatusText() + ", duration=" + this.getDuration() + ", sseId=" + this.getSseId() + ", authorizationToken=" + this.getAuthorizationToken() + ", testingStatus=" + (Object)((Object)this.getTestingStatus()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestExecution)) {
            return false;
        }
        RequestExecution other = (RequestExecution)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        UUID this$projectId = this.getProjectId();
        UUID other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        TransportType this$transportType = this.getTransportType();
        TransportType other$transportType = other.getTransportType();
        if (this$transportType == null ? other$transportType != null : !((Object)((Object)this$transportType)).equals((Object)other$transportType)) {
            return false;
        }
        Date this$executedWhen = this.getExecutedWhen();
        Date other$executedWhen = other.getExecutedWhen();
        if (this$executedWhen == null ? other$executedWhen != null : !((Object)this$executedWhen).equals(other$executedWhen)) {
            return false;
        }
        String this$executor = this.getExecutor();
        String other$executor = other.getExecutor();
        if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
            return false;
        }
        String this$statusCode = this.getStatusCode();
        String other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !this$statusCode.equals(other$statusCode)) {
            return false;
        }
        String this$statusText = this.getStatusText();
        String other$statusText = other.getStatusText();
        if (this$statusText == null ? other$statusText != null : !this$statusText.equals(other$statusText)) {
            return false;
        }
        BigInteger this$duration = this.getDuration();
        BigInteger other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        UUID this$sseId = this.getSseId();
        UUID other$sseId = other.getSseId();
        if (this$sseId == null ? other$sseId != null : !((Object)this$sseId).equals(other$sseId)) {
            return false;
        }
        String this$authorizationToken = this.getAuthorizationToken();
        String other$authorizationToken = other.getAuthorizationToken();
        if (this$authorizationToken == null ? other$authorizationToken != null : !this$authorizationToken.equals(other$authorizationToken)) {
            return false;
        }
        TestingStatus this$testingStatus = this.getTestingStatus();
        TestingStatus other$testingStatus = other.getTestingStatus();
        return !(this$testingStatus == null ? other$testingStatus != null : !((Object)((Object)this$testingStatus)).equals((Object)other$testingStatus));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RequestExecution;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        UUID $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        TransportType $transportType = this.getTransportType();
        result = result * 59 + ($transportType == null ? 43 : ((Object)((Object)$transportType)).hashCode());
        Date $executedWhen = this.getExecutedWhen();
        result = result * 59 + ($executedWhen == null ? 43 : ((Object)$executedWhen).hashCode());
        String $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        String $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : $statusCode.hashCode());
        String $statusText = this.getStatusText();
        result = result * 59 + ($statusText == null ? 43 : $statusText.hashCode());
        BigInteger $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        UUID $sseId = this.getSseId();
        result = result * 59 + ($sseId == null ? 43 : ((Object)$sseId).hashCode());
        String $authorizationToken = this.getAuthorizationToken();
        result = result * 59 + ($authorizationToken == null ? 43 : $authorizationToken.hashCode());
        TestingStatus $testingStatus = this.getTestingStatus();
        result = result * 59 + ($testingStatus == null ? 43 : ((Object)((Object)$testingStatus)).hashCode());
        return result;
    }

    public RequestExecution() {
    }
}

