/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.entities.http;

import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.javers.core.metamodel.annotation.DiffInclude;
import org.javers.core.metamodel.annotation.ValueObject;
import org.qubership.atp.itf.lite.backend.model.api.Parameter;
import org.qubership.atp.itf.lite.backend.model.api.request.http.HttpParamSaveRequest;
import org.qubership.atp.itf.lite.backend.model.entities.AbstractNamedEntity;

@Entity
@ValueObject
@Table(name="request_params")
public class RequestParam
extends AbstractNamedEntity
implements Parameter {
    @Column(name="key")
    @DiffInclude
    private String key;
    @Column(name="value", columnDefinition="TEXT")
    @DiffInclude
    private String value;
    @Column(name="description")
    @DiffInclude
    private String description;
    @Column(name="disabled")
    @DiffInclude
    private boolean disabled;
    @Column(name="generated")
    private boolean generated;

    public RequestParam(UUID id, String key, String value, String description, boolean isDisabled, boolean generated) {
        this.id = id;
        this.key = key;
        this.value = value;
        this.description = description;
        this.disabled = isDisabled;
        this.generated = generated;
    }

    public RequestParam(UUID id, String key, String value, String description, boolean isDisabled) {
        this(id, key, value, description, isDisabled, false);
    }

    public RequestParam(String key, String value, String description, boolean isDisabled) {
        this(null, key, value, description, isDisabled);
    }

    public RequestParam(String key, String value, String description, boolean isDisabled, boolean generated) {
        this(null, key, value, description, isDisabled, generated);
    }

    public RequestParam(HttpParamSaveRequest param) {
        this.key = param.getKey();
        this.value = param.getValue();
        this.description = param.getDescription();
        this.disabled = param.isDisabled();
        this.generated = param.isGenerated();
        this.id = param.getId();
    }

    public RequestParam(RequestParam requestParam) {
        this.key = requestParam.getKey();
        this.value = requestParam.getValue();
        this.description = requestParam.getDescription();
        this.disabled = requestParam.isDisabled();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setGenerated(boolean generated) {
        this.generated = generated;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestParam)) {
            return false;
        }
        RequestParam other = (RequestParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDisabled() != other.isDisabled()) {
            return false;
        }
        if (this.isGenerated() != other.isGenerated()) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RequestParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDisabled() ? 79 : 97);
        result = result * 59 + (this.isGenerated() ? 79 : 97);
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "RequestParam(key=" + this.getKey() + ", value=" + this.getValue() + ", description=" + this.getDescription() + ", disabled=" + this.isDisabled() + ", generated=" + this.isGenerated() + ")";
    }

    public RequestParam() {
    }
}

