/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.schedulers;

import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.qubership.atp.itf.lite.backend.utils.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class CachedFilesCleaner {
    private static final Logger log = LoggerFactory.getLogger(CachedFilesCleaner.class);
    private static final List<Path> listOfDirectories = Arrays.asList(Constants.DEFAULT_BINARY_FILES_FOLDER, Constants.DEFAULT_FORM_DATA_FOLDER);
    @Value(value="${atp.itf.lite.clean.file.cache.time-sec}")
    private String cleanFileCacheTimeout;

    @Scheduled(cron="${atp.itf.lite.clean.file.cache.cron.expression}")
    public void filesCleanUpJob() {
        log.debug("Start cleaning files in directories {}.", listOfDirectories);
        this.deleteOldFiles(listOfDirectories);
    }

    public void deleteOldFiles(List<Path> directories) {
        ArrayList listOfDeletedFiles = new ArrayList();
        directories.forEach(directory -> {
            if (Files.exists(directory, new LinkOption[0])) {
                try (Stream<Path> pathStream = Files.walk(directory, new FileVisitOption[0]);){
                    pathStream.sorted(Comparator.reverseOrder()).map(Path::toFile).filter(file -> file.isFile() && System.currentTimeMillis() - file.lastModified() > Long.parseLong(this.cleanFileCacheTimeout)).forEach(file -> {
                        try {
                            if (file.delete()) {
                                listOfDeletedFiles.add(file.getAbsolutePath());
                            }
                        }
                        catch (Exception e) {
                            log.error("Can not delete file {}", (Object)file.getPath(), (Object)e);
                        }
                    });
                }
                catch (Exception e) {
                    log.error("Can not delete files from directory {}", directory, (Object)e);
                }
            }
        });
        log.debug("Lod of deleted files: {}", listOfDeletedFiles);
    }
}

