/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.schedulers;

import org.qubership.atp.common.lock.LockManager;
import org.qubership.atp.itf.lite.backend.service.CollectionRunService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class CollectionRunsCleaner {
    private static final Logger log = LoggerFactory.getLogger(CollectionRunsCleaner.class);
    private static final String UTC_TIMEZONE = "UTC";
    @Value(value="${atp.itf.lite.collection.runs.remove.days}")
    private int collectionRunsRemoveDays;
    private final LockManager lockManager;
    private final CollectionRunService collectionRunService;

    public CollectionRunsCleaner(LockManager lockManager, CollectionRunService collectionRunService) {
        this.lockManager = lockManager;
        this.collectionRunService = collectionRunService;
    }

    @Scheduled(cron="${atp.itf.lite.collection.runs.cron.expression}", zone="UTC")
    public void collectionRunsCleanupWithLockManager() {
        this.lockManager.executeWithLock("cleanUpCollectionRuns", this::cleanUpCollectionRuns);
    }

    public void cleanUpCollectionRuns() {
        log.info("Start collection runs clean up");
        this.collectionRunService.cleanUpRequestExecutionHistory(this.collectionRunsRemoveDays);
        log.info("Finish collection runs clean up");
    }
}

