/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.schedulers;

import java.io.IOException;
import org.qubership.atp.common.lock.LockManager;
import org.qubership.atp.itf.lite.backend.service.GridFsService;
import org.qubership.atp.itf.lite.backend.utils.Constants;
import org.qubership.atp.itf.lite.backend.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class DictionariesCleaner {
    private static final Logger log = LoggerFactory.getLogger(DictionariesCleaner.class);
    @Value(value="${gridfs.dictionary.remove.days}")
    private Integer fileRemoveDays;
    private final LockManager lockManager;
    private final GridFsService gridFsService;

    @Autowired
    public DictionariesCleaner(LockManager lockManager, GridFsService gridFsService) {
        this.lockManager = lockManager;
        this.gridFsService = gridFsService;
    }

    @Scheduled(cron="0 0/30 * * * *")
    public void dictionariesCleanupWithLockManager() {
        this.lockManager.executeWithLock("dictionariesCleanup", this::dictionariesCleanup);
    }

    public void dictionariesCleanup() {
        try {
            FileUtils.deleteDirectoryRecursively(Constants.DEFAULT_DICTIONARIES_FOLDER);
        }
        catch (IOException exception) {
            log.error("Can't cleanup dictionaries folder.", (Throwable)exception);
        }
    }

    @Scheduled(cron="0 1 1 * * ?")
    public void gridFsDictionariesCleanupWithLockManager() {
        this.lockManager.executeWithLock("gridFsDictionariesCleanup", this::gridFsFilesCleanup);
    }

    public void gridFsFilesCleanup() {
        this.gridFsService.removeFilesByDate(this.fileRemoveDays);
    }
}

