/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.schedulers;

import java.sql.Timestamp;
import java.util.Calendar;
import org.qubership.atp.common.lock.LockManager;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.GetAuthorizationCodeRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class GetAccessTokenCleanup {
    private static final Logger log = LoggerFactory.getLogger(GetAccessTokenCleanup.class);
    private final int retentionInDays = -1;
    private final LockManager lockManager;
    private final GetAuthorizationCodeRepository getAuthorizationCodeRepository;

    @Scheduled(cron="${getaccesstoken.retention.cron.expression}")
    public void getAccessTokenCleanup() {
        this.lockManager.executeWithLock("getAccessTokenCleanup", () -> {
            log.info("Start cleanUp of 'Get new access token' records");
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -1);
            log.info("getAccessTokenCleanup procedure delete {} records", (Object)this.getAuthorizationCodeRepository.deleteByStartedAtBefore(new Timestamp(calendar.getTimeInMillis())));
            log.info("Finish cleanUp of 'Get new access token' records");
        });
    }

    public GetAccessTokenCleanup(LockManager lockManager, GetAuthorizationCodeRepository getAuthorizationCodeRepository) {
        this.lockManager = lockManager;
        this.getAuthorizationCodeRepository = getAuthorizationCodeRepository;
    }
}

