/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.qubership.atp.adapter.common.entities.Message;
import org.qubership.atp.adapter.executor.executor.AtpRamWriter;
import org.qubership.atp.itf.lite.backend.catalog.models.ActionEntity;
import org.qubership.atp.itf.lite.backend.catalog.models.ActionParameter;
import org.qubership.atp.itf.lite.backend.catalog.models.ComplexActionParameter;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.ActionRepository;
import org.qubership.atp.itf.lite.backend.enums.ActionName;
import org.qubership.atp.itf.lite.backend.enums.EntityType;
import org.qubership.atp.itf.lite.backend.exceptions.ItfLiteException;
import org.qubership.atp.itf.lite.backend.exceptions.action.ItfLiteActionNotFoundException;
import org.qubership.atp.itf.lite.backend.feign.service.RamService;
import org.qubership.atp.itf.lite.backend.model.api.request.ExecutionCollectionRequestExecuteRequest;
import org.qubership.atp.itf.lite.backend.model.api.response.GroupResponse;
import org.qubership.atp.itf.lite.backend.model.api.response.collections.ContextEntity;
import org.qubership.atp.itf.lite.backend.model.api.response.collections.ExecuteStepResponse;
import org.qubership.atp.itf.lite.backend.model.entities.Action;
import org.qubership.atp.itf.lite.backend.model.entities.Request;
import org.qubership.atp.itf.lite.backend.service.FolderService;
import org.qubership.atp.itf.lite.backend.service.RequestService;
import org.qubership.atp.ram.enums.ExecutionStatuses;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.enums.TypeAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ActionService {
    private static final Logger log = LoggerFactory.getLogger(ActionService.class);
    private final ActionRepository repository;
    private final FolderService folderService;
    private final RequestService requestService;
    private final RamService ramService;
    private final ObjectMapper objectMapper;
    private static final String KEY = "key";
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{(?<key>[^}]+)\\}");

    public List<Action> getActions(UUID projectId) {
        return this.repository.findAll();
    }

    public ExecuteStepResponse executeAction(ExecutionCollectionRequestExecuteRequest request, UUID environmentId) {
        this.ramService.provideInfo(request);
        ExecuteStepResponse response = new ExecuteStepResponse();
        Function<ExecutionCollectionRequestExecuteRequest, ExecuteStepResponse> actionStrategy = null;
        try {
            this.compileActionName(request.getActionEntity(), request.getContext());
            actionStrategy = this.getStrategyByAction(request.getActionEntity(), request.getProjectId(), environmentId, request.getContext());
        }
        catch (Exception ex) {
            log.error("Failed to get action strategy by action {}", (Object)request.getActionEntity().getName(), (Object)ex);
            this.ramService.updateMessageAndTestingStatus(ex.getMessage(), TestingStatuses.FAILED);
            response.setTestingStatus(TestingStatuses.FAILED);
        }
        try {
            if (Objects.nonNull(actionStrategy)) {
                response = actionStrategy.apply(request);
            }
        }
        catch (Exception ex) {
            log.error("Failed to execute action {}", (Object)request.getActionEntity().getName(), (Object)ex);
            this.ramService.updateMessageAndTestingStatus(ex.getMessage(), TestingStatuses.FAILED);
            response.setTestingStatus(TestingStatuses.FAILED);
        }
        return response;
    }

    private Function<ExecutionCollectionRequestExecuteRequest, ExecuteStepResponse> getStrategyByAction(ActionEntity action, UUID projectId, UUID environmentId, Map<String, Object> context) {
        if (CollectionUtils.isEmpty((Collection)action.getParameters())) {
            log.error("Action parameters are null or empty");
            throw new ItfLiteException("Action parameters are null or empty");
        }
        String actionName = action.getName();
        if (actionName.matches(ActionName.EXECUTE_REQUEST_BY_ID.getRegexp())) {
            String requestIdStr = this.resolveActionParameter(((ActionParameter)action.getParameters().get(0)).getValue(), context);
            try {
                UUID requestId = UUID.fromString(requestIdStr);
                return this.getExecuteRequestActionStrategy(requestId, environmentId);
            }
            catch (IllegalArgumentException ex) {
                log.error("Failed to parse requestId from action parameter: {}", (Object)requestIdStr, (Object)ex);
                throw new ItfLiteException(String.format("Failed to get requestId - bad uuid format: %s", requestIdStr));
            }
        }
        if (actionName.matches(ActionName.EXECUTE_FOLDER_BY_ID.getRegexp())) {
            String folderIdStr = this.resolveActionParameter(((ActionParameter)action.getParameters().get(0)).getValue(), context);
            try {
                UUID folderId = UUID.fromString(folderIdStr);
                return this.getExecuteFolderStrategy(folderId, environmentId);
            }
            catch (IllegalArgumentException ex) {
                log.error("Failed to parse folderId from action parameter: {}", (Object)folderIdStr, (Object)ex);
                throw new ItfLiteException(String.format("Failed to get folderId - bad uuid format: %s", folderIdStr));
            }
        }
        if (actionName.matches(ActionName.EXECUTE_FOLDER_BY_PATH.getRegexp())) {
            ComplexActionParameter complexParam = ((ActionParameter)action.getParameters().get(0)).getComplexParam();
            if (Objects.isNull(complexParam)) {
                log.error("ComplexActionParameters are null");
                throw new ItfLiteException("ComplexActionParameters are null");
            }
            List actionParameters = complexParam.getArrayParams();
            if (CollectionUtils.isEmpty((Collection)actionParameters)) {
                log.error("Action parameters are null or empty");
                throw new ItfLiteException("Action parameters are null or empty");
            }
            List<String> path = actionParameters.stream().map(ActionParameter::getValue).collect(Collectors.toList());
            this.resolveActionParameters(path, context);
            UUID folderId = this.folderService.getIdByFoldersPath(projectId, path);
            return this.getExecuteFolderStrategy(folderId, environmentId);
        }
        throw new ItfLiteActionNotFoundException(action.getName());
    }

    private Function<ExecutionCollectionRequestExecuteRequest, ExecuteStepResponse> getExecuteRequestActionStrategy(UUID requestId, UUID environmentId) {
        return requestExecuteRequest -> {
            log.debug("Check if request with requestId {} exists", (Object)requestId);
            Request request = this.requestService.getRequestByProjectIdAndRequestId(requestExecuteRequest.getProjectId(), requestId);
            if (requestExecuteRequest.getActionEntity().getName().contains(requestId.toString())) {
                log.debug("Replace requestId = {} by requestName = {} in action entity.", (Object)requestId, (Object)request.getName());
                this.ramService.updateExecutionLogRecordName((ExecutionCollectionRequestExecuteRequest)requestExecuteRequest, requestExecuteRequest.getActionEntity().getName().replace(requestId.toString(), request.getName()));
            }
            return this.requestService.executeRequestWithRamAdapterLogging((ExecutionCollectionRequestExecuteRequest)requestExecuteRequest, request, environmentId);
        };
    }

    private Function<ExecutionCollectionRequestExecuteRequest, ExecuteStepResponse> getExecuteFolderStrategy(UUID folderId, UUID environmentId) {
        return requestExecuteRequest -> {
            ExecuteStepResponse response = new ExecuteStepResponse();
            try {
                GroupResponse requestTree = this.folderService.getRequestTreeByParentFolderId(folderId);
                String actionName = requestExecuteRequest.getActionEntity().getName();
                if (actionName.contains(folderId.toString())) {
                    log.debug("Replace folderId = {} by folderName = {} in action entity.", (Object)folderId, (Object)requestTree.getName());
                    this.ramService.updateExecutionLogRecordName((ExecutionCollectionRequestExecuteRequest)requestExecuteRequest, actionName.replace(folderId.toString(), requestTree.getName()));
                }
                response = this.executeFolderRequests(requestTree, (ExecutionCollectionRequestExecuteRequest)requestExecuteRequest, environmentId);
                response.setStatus(ExecutionStatuses.FINISHED);
            }
            catch (Exception ex) {
                log.error("Failed to execute folder action by id {}", (Object)folderId, (Object)ex);
                this.ramService.updateMessageAndTestingStatus(ex.getMessage(), TestingStatuses.FAILED);
                response.setTestingStatus(TestingStatuses.FAILED);
            }
            return response;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecuteStepResponse executeFolderRequests(GroupResponse requestTree, ExecutionCollectionRequestExecuteRequest requestExecuteRequest, UUID environmentId) {
        ExecuteStepResponse response = new ExecuteStepResponse();
        TestingStatuses finalStatus = TestingStatuses.PASSED;
        List<GroupResponse> children = requestTree.getChildren();
        if (!CollectionUtils.isEmpty(children)) {
            for (GroupResponse child : children) {
                if (EntityType.FOLDER.equals((Object)child.getType())) {
                    if (CollectionUtils.isEmpty(child.getChildren())) continue;
                    AtpRamWriter ramWriter = AtpRamWriter.getAtpRamWriter();
                    Message msg = new Message();
                    msg.setName(child.getName());
                    msg.setType(TypeAction.COMPOUND.toString());
                    ramWriter.openSection(msg);
                    try {
                        response = this.executeFolderRequests(child, requestExecuteRequest, environmentId);
                        finalStatus = TestingStatuses.PASSED.equals((Object)finalStatus) && (TestingStatuses.PASSED.equals((Object)response.getTestingStatus()) || TestingStatuses.SKIPPED.equals((Object)response.getTestingStatus())) ? TestingStatuses.PASSED : TestingStatuses.FAILED;
                        continue;
                    }
                    finally {
                        ramWriter.closeSection(null);
                        continue;
                    }
                }
                ExecuteStepResponse newResponse = this.executeRequest(child.getId(), requestExecuteRequest, environmentId);
                response.setContext(newResponse.getContext());
                finalStatus = TestingStatuses.PASSED.equals((Object)finalStatus) && (TestingStatuses.PASSED.equals((Object)newResponse.getTestingStatus()) || TestingStatuses.SKIPPED.equals((Object)newResponse.getTestingStatus())) ? TestingStatuses.PASSED : TestingStatuses.FAILED;
                response.setContext(newResponse.getContext());
                response.setMetadata(newResponse.getMetadata());
            }
        }
        response.setTestingStatus(finalStatus);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecuteStepResponse executeRequest(UUID requestId, ExecutionCollectionRequestExecuteRequest parentRer, UUID environmentId) {
        ExecuteStepResponse response;
        Request request = this.requestService.getRequestByProjectIdAndRequestId(parentRer.getProjectId(), requestId);
        Message itfMessage = new Message();
        itfMessage.setName(String.format("%s \"%s\"", ActionName.EXECUTE_REQUEST_BY_ID.getName(), request.getName()));
        itfMessage.setExecutionStatus(ExecutionStatuses.IN_PROGRESS.name());
        itfMessage.setType(TypeAction.ITF.toString());
        AtpRamWriter writer = AtpRamWriter.getAtpRamWriter();
        writer.openSection(itfMessage);
        try {
            response = this.requestService.executeRequestWithRamAdapterLogging(parentRer, request, environmentId);
            Map<String, Object> newContext = this.getContextAfterExecution(response);
            writer.getAdapter().updateContextVariables(writer.getContext().getLogRecordUuid(), this.ramService.getContextVariables(parentRer.getContext(), newContext));
            parentRer.setContext(newContext);
        }
        finally {
            writer.closeSection(null);
        }
        return response;
    }

    private Map<String, Object> getContextAfterExecution(ExecuteStepResponse response) {
        String contextStr;
        ContextEntity context = response.getContext();
        if (Objects.nonNull(context) && !StringUtils.isEmpty((Object)(contextStr = context.getJsonString()))) {
            try {
                return (Map)this.objectMapper.readValue(contextStr, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
            }
            catch (JsonProcessingException ex) {
                log.error("Failed to convert execution context from string", (Throwable)ex);
                throw new ItfLiteException("Failed to read execution context");
            }
        }
        return null;
    }

    private void resolveActionParameters(List<String> parameters, Map<String, Object> context) {
        ListIterator<String> i = parameters.listIterator();
        while (i.hasNext()) {
            i.set(this.resolveActionParameter(i.next(), context));
        }
    }

    private String resolveActionParameter(String parameter, Map<String, Object> context) {
        String key;
        Object value;
        Matcher matcher = VARIABLE_PATTERN.matcher(parameter);
        if (matcher.matches() && Objects.nonNull(value = context.get(key = matcher.group(KEY)))) {
            return matcher.replaceFirst(value.toString());
        }
        return parameter;
    }

    public void compileActionName(ActionEntity action, Map<String, Object> context) {
        if (context != null) {
            for (String key : context.keySet()) {
                Object value = context.get(key);
                if (!Objects.nonNull(value)) continue;
                action.setName(action.getName().replaceAll("\\$\\{" + key + "}", value.toString()));
            }
        }
        for (ActionParameter actionParameter : action.getParameters()) {
            if (!Objects.nonNull(actionParameter.getName()) || !Objects.nonNull(actionParameter.getValue())) continue;
            action.setName(action.getName().replaceAll("\\$\\{" + actionParameter.getName() + "}", actionParameter.getValue()));
        }
    }

    public ActionService(ActionRepository repository, FolderService folderService, RequestService requestService, RamService ramService, ObjectMapper objectMapper) {
        this.repository = repository;
        this.folderService = folderService;
        this.requestService = requestService;
        this.ramService = ramService;
        this.objectMapper = objectMapper;
    }
}

