/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpException;
import org.qubership.atp.ei.ntt.dto.AbstractTestScenario;
import org.qubership.atp.itf.lite.backend.catalog.models.Directive;
import org.qubership.atp.itf.lite.backend.catalog.models.DirectiveEnum;
import org.qubership.atp.itf.lite.backend.enums.EntityType;
import org.qubership.atp.itf.lite.backend.enums.ImportCollectionError;
import org.qubership.atp.itf.lite.backend.enums.ImportCollectionStatus;
import org.qubership.atp.itf.lite.backend.enums.TransportType;
import org.qubership.atp.itf.lite.backend.enums.ValueType;
import org.qubership.atp.itf.lite.backend.enums.auth.RequestAuthorizationType;
import org.qubership.atp.itf.lite.backend.enums.http.RequestBodyMode;
import org.qubership.atp.itf.lite.backend.enums.http.RequestBodyType;
import org.qubership.atp.itf.lite.backend.exceptions.collection.ItfLiteImportCollectionFileExtensionNotFoundException;
import org.qubership.atp.itf.lite.backend.exceptions.collection.ItfLiteImportCollectionFileParseProcessException;
import org.qubership.atp.itf.lite.backend.exceptions.collection.ItfLiteImportCollectionFileProcessException;
import org.qubership.atp.itf.lite.backend.feign.dto.ActionEntityDto;
import org.qubership.atp.itf.lite.backend.feign.dto.DirectiveDto;
import org.qubership.atp.itf.lite.backend.feign.dto.EnrichedCompoundDto;
import org.qubership.atp.itf.lite.backend.feign.dto.EnrichedScenarioDto;
import org.qubership.atp.itf.lite.backend.feign.dto.ExecuteRequestDto;
import org.qubership.atp.itf.lite.backend.feign.dto.TypeEnum;
import org.qubership.atp.itf.lite.backend.feign.dto.history.ActionParameterDto;
import org.qubership.atp.itf.lite.backend.feign.service.CatalogueService;
import org.qubership.atp.itf.lite.backend.feign.service.EnvironmentFeignService;
import org.qubership.atp.itf.lite.backend.feign.service.RamService;
import org.qubership.atp.itf.lite.backend.model.api.request.CollectionExecuteRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.FolderUpsetRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.ImportCollectionsRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.AuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.response.GroupResponse;
import org.qubership.atp.itf.lite.backend.model.api.response.ImportCollectionsResponse;
import org.qubership.atp.itf.lite.backend.model.api.response.environments.System;
import org.qubership.atp.itf.lite.backend.model.entities.Cookie;
import org.qubership.atp.itf.lite.backend.model.entities.Folder;
import org.qubership.atp.itf.lite.backend.model.entities.Request;
import org.qubership.atp.itf.lite.backend.model.entities.RequestBody;
import org.qubership.atp.itf.lite.backend.model.entities.auth.InheritFromParentRequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.RequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.http.FormDataPart;
import org.qubership.atp.itf.lite.backend.model.entities.http.HttpRequest;
import org.qubership.atp.itf.lite.backend.model.entities.http.RequestHeader;
import org.qubership.atp.itf.lite.backend.model.entities.http.RequestParam;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpMethod;
import org.qubership.atp.itf.lite.backend.service.CookieService;
import org.qubership.atp.itf.lite.backend.service.DynamicVariablesService;
import org.qubership.atp.itf.lite.backend.service.FolderService;
import org.qubership.atp.itf.lite.backend.service.MetricService;
import org.qubership.atp.itf.lite.backend.service.RequestAuthorizationService;
import org.qubership.atp.itf.lite.backend.service.RequestService;
import org.qubership.atp.itf.lite.backend.utils.AuthorizationUtils;
import org.qubership.atp.itf.lite.backend.utils.StreamUtils;
import org.qubership.atp.itf.lite.backend.utils.UrlParsingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CollectionsService {
    private static final Logger log = LoggerFactory.getLogger(CollectionsService.class);
    private final FolderService folderService;
    private final RequestService requestService;
    private final RequestAuthorizationService requestAuthorizationService;
    private final EnvironmentFeignService environmentService;
    private final RamService ramService;
    private final CatalogueService catalogueService;
    private final MetricService metricService;
    private final DynamicVariablesService dynamicVariablesService;
    private final CookieService cookieService;
    private static final List<HttpMethod> availableHTTPMethods = Arrays.asList(HttpMethod.values());
    private static final String REQUEST_WITHOUT_FILE_MESSAGE_FORMAT = "Request was imported without a file %s";

    @Transactional
    public List<ImportCollectionsResponse> importCollections(MultipartFile file, ImportCollectionsRequest request) {
        List<ImportCollectionsResponse> results;
        UUID projectId = request.getProjectId();
        UUID updatedId = request.getTargetFolderId();
        String collectionName = request.getCollectionName();
        log.info("Import collection: [projectId: {}, collectionName: {}, targetFolderId: {}]", new Object[]{projectId, collectionName, updatedId});
        ArrayList<String> collections = new ArrayList<String>();
        try (InputStream inputStream = file.getInputStream();){
            String extension = FilenameUtils.getExtension((String)file.getOriginalFilename());
            if (extension == null) {
                log.error("The extension of the imported file is null. ImportCollectionRequest: [projectId:{}, collectionName:{}, targetFolderId:{}]", new Object[]{projectId, collectionName, updatedId});
                throw new ItfLiteImportCollectionFileExtensionNotFoundException();
            }
            if ("zip".equals(extension)) {
                collections.addAll(this.readFilesFromZip(inputStream));
            } else {
                collections.add(IOUtils.toString((InputStream)inputStream));
            }
        }
        catch (IOException e) {
            log.error("Error while processing file. ImportCollectionsRequest: [projectId:{}, collectionName:{}]", new Object[]{projectId, collectionName, e});
            throw new ItfLiteImportCollectionFileProcessException();
        }
        try {
            results = this.parseCollections(request, collections);
        }
        catch (AtpException ex) {
            log.error("Error while parsing file. ImportCollectionsRequest: [projectId:{}, collectionName:{}]", new Object[]{projectId, collectionName, ex});
            throw ex;
        }
        catch (Exception e) {
            log.error("Error while parsing file. ImportCollectionsRequest: [projectId:{}, collectionName:{}]", new Object[]{projectId, collectionName, e});
            throw new ItfLiteImportCollectionFileParseProcessException();
        }
        return results;
    }

    private List<String> readFilesFromZip(InputStream inputStream) throws IOException {
        ArrayList<String> collections = new ArrayList<String>();
        try (ZipInputStream zis = new ZipInputStream(inputStream);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                String extension;
                if (entry.isDirectory() || !"json".equals(extension = FilenameUtils.getExtension((String)entry.getName()))) continue;
                collections.add(IOUtils.toString((InputStream)zis));
            }
        }
        return collections;
    }

    private List<ImportCollectionsResponse> parseCollections(ImportCollectionsRequest request, List<String> collections) throws Exception {
        if (collections.isEmpty()) {
            return Collections.emptyList();
        }
        Folder collectionsFolder = this.folderService.createFolder(new FolderUpsetRequest(request.getCollectionName(), request.getProjectId(), request.getTargetFolderId(), null, false, false, false, false, false, "", null, new Date()));
        ArrayList<ImportCollectionsResponse> result = new ArrayList<ImportCollectionsResponse>();
        String collectionName = request.getCollectionName();
        for (String collection : collections) {
            JsonObject jsonObject = JsonParser.parseString((String)collection).getAsJsonObject();
            JsonArray items = jsonObject.getAsJsonArray("item");
            Folder collectionFolder = collectionsFolder;
            if (collections.size() > 1) {
                collectionName = ((JsonElement)jsonObject.getAsJsonObject("info").asMap().get("name")).toString();
                String collectionDescription = ((JsonElement)jsonObject.getAsJsonObject("info").asMap().get("description")).toString();
                RequestAuthorization authorization = this.parseAuthorization(collectionsFolder, jsonObject);
                AuthorizationSaveRequest authorizationSaveRequest = null;
                if (Objects.nonNull(authorization)) {
                    authorizationSaveRequest = AuthorizationUtils.castToAuthorizationSaveRequest(authorization);
                }
                collectionFolder = this.folderService.createFolder(new FolderUpsetRequest(collectionName, request.getProjectId(), collectionsFolder.getId(), null, false, false, false, false, false, collectionDescription, authorizationSaveRequest, new Date()));
            } else {
                RequestAuthorization authorization = this.parseAuthorization(null, jsonObject);
                collectionFolder.setAuthorization(authorization);
                this.folderService.save(collectionFolder);
            }
            result.addAll(this.parseCollection(collectionName, collectionFolder, items));
        }
        return result;
    }

    private List<ImportCollectionsResponse> parseCollection(String collectionName, Folder parentFolder, JsonArray items) throws Exception {
        ArrayList<ImportCollectionsResponse> result = new ArrayList<ImportCollectionsResponse>();
        for (Object obj : items) {
            List<ImportCollectionsResponse> response;
            JsonObject item = (JsonObject)obj;
            if (item.has("item")) {
                result.addAll(this.parseFolder(collectionName, parentFolder, item));
                continue;
            }
            if (!item.has("request") || (response = this.parseRequest(collectionName, parentFolder, item)) == null) continue;
            result.addAll(response);
        }
        return result;
    }

    private List<ImportCollectionsResponse> parseFolder(String collectionName, Folder parentFolder, JsonObject folder) throws Exception {
        String folderName = folder.getAsJsonPrimitive("name").getAsString();
        String description = folder.getAsJsonPrimitive("description") != null ? folder.getAsJsonPrimitive("description").getAsString() : "";
        RequestAuthorization authorization = this.parseAuthorization(parentFolder, folder);
        AuthorizationSaveRequest authorizationSaveRequest = null;
        if (Objects.nonNull(authorization)) {
            authorizationSaveRequest = AuthorizationUtils.castToAuthorizationSaveRequest(authorization);
        }
        Folder childFolder = this.folderService.createFolder(new FolderUpsetRequest(folderName, parentFolder.getProjectId(), parentFolder.getId(), null, false, false, false, false, false, description, authorizationSaveRequest, new Date()));
        log.info("Parsed folder: {}, projectId: {}, folderId: {}, parentFolderId: {}", new Object[]{folderName, childFolder.getProjectId(), childFolder.getId(), childFolder.getParentId()});
        JsonArray childFolders = folder.getAsJsonArray("item");
        return this.parseCollection(collectionName, childFolder, childFolders);
    }

    private List<ImportCollectionsResponse> parseRequest(String collectionName, Folder parentFolder, JsonObject requestItem) {
        String requestName = requestItem.getAsJsonPrimitive("name").getAsString();
        HttpRequest newRequest = new HttpRequest();
        newRequest.setDescription(requestItem.getAsJsonPrimitive("description") != null ? requestItem.getAsJsonPrimitive("description").getAsString() : "");
        newRequest.setName(requestName);
        newRequest.setProjectId(parentFolder.getProjectId());
        newRequest.setFolderId(parentFolder.getId());
        newRequest.setTransportType(TransportType.REST);
        log.info("Parse postman request: \"{}\", projectId: {} folderId: {}, collectionName: {}", new Object[]{requestName, parentFolder.getProjectId(), parentFolder.getId(), collectionName});
        Set<String> dynamicVariables = DynamicVariablesService.getDynamicVariables(requestItem.toString());
        JsonObject jsonRequest = requestItem.getAsJsonObject("request");
        String method = jsonRequest.getAsJsonPrimitive("method").getAsString();
        HttpMethod httpMethod = HttpMethod.resolve(method);
        if (!availableHTTPMethods.contains((Object)httpMethod)) {
            log.info("Parse postman request \"{}\" failed: Unsupported method is used: {}", (Object)requestName, (Object)method);
            return Arrays.asList(new ImportCollectionsResponse(requestName, null, collectionName, "Unsupported method is used: " + method, ImportCollectionStatus.ERROR, null, null));
        }
        newRequest.setHttpMethod(httpMethod);
        newRequest.setRequestHeaders(this.parseRequestHeaders(jsonRequest));
        if (jsonRequest.has("url")) {
            if (jsonRequest.get("url").isJsonObject()) {
                JsonObject urlItem = jsonRequest.getAsJsonObject("url");
                newRequest.setUrl(this.parseRequestUrl(urlItem));
                newRequest.setRequestParams(this.parseRequestParameters(urlItem));
            } else {
                UrlParsingUtils.parseUrlAndRequestParams(newRequest, jsonRequest.get("url").toString());
            }
        }
        if (requestItem.has("event")) {
            this.parseEvents(newRequest, requestItem, dynamicVariables);
        }
        RequestBody requestBody = new RequestBody();
        List<ImportCollectionsResponse> result = this.parseRequestBody(requestBody, jsonRequest, newRequest);
        this.processContentTypeHeader(newRequest.getRequestHeaders(), requestBody);
        if (!CollectionUtils.isEmpty(result)) {
            boolean isError = false;
            for (ImportCollectionsResponse res2 : result) {
                if (ImportCollectionStatus.ERROR.equals((Object)res2.getImportStatus())) {
                    log.error("Found import result with error status - break request importing");
                    isError = true;
                }
                res2.setRequestName(requestName);
                res2.setCollectionName(collectionName);
            }
            if (isError) {
                return result;
            }
        }
        newRequest.setBody(requestBody);
        RequestAuthorization requestAuthorization = this.parseAuthorization(parentFolder, jsonRequest);
        newRequest.setAuthorization(requestAuthorization);
        Request resultRequest = this.requestService.createRequest(newRequest);
        if (!CollectionUtils.isEmpty(result)) {
            result.forEach(res -> res.setRequestId(resultRequest.getId()));
        }
        log.info("Request {} parsed", (Object)requestName);
        return result;
    }

    private void parseEvents(HttpRequest request, JsonObject requestItem, Set<String> dynamicVariables) {
        JsonArray events = requestItem.getAsJsonArray("event");
        for (Object eventObj : events) {
            JsonObject event = (JsonObject)eventObj;
            JsonObject script = event.getAsJsonObject("script");
            StringJoiner joiner = new StringJoiner("\n");
            for (Object partOfScript : script.getAsJsonArray("exec")) {
                JsonPrimitive part = (JsonPrimitive)partOfScript;
                joiner.add(String.valueOf(part.getAsString()).trim());
            }
            if ("prerequest".equals(event.getAsJsonPrimitive("listen").getAsString())) {
                request.setPreScripts(this.dynamicVariablesService.insertDynamicVariablesIntoPreScripts(joiner.toString(), dynamicVariables));
            } else if (!dynamicVariables.isEmpty()) {
                request.setPreScripts(this.dynamicVariablesService.insertDynamicVariablesIntoPreScripts("", dynamicVariables));
            }
            if (!"test".equals(event.getAsJsonPrimitive("listen").getAsString())) continue;
            request.setPostScripts(joiner.toString());
        }
    }

    private List<RequestHeader> parseRequestHeaders(JsonObject request) {
        ArrayList<RequestHeader> headers = new ArrayList<RequestHeader>();
        if (request.asMap().containsKey("header")) {
            JsonArray headersArray = request.getAsJsonArray("header");
            for (Object header : headersArray) {
                JsonObject headerItem = (JsonObject)header;
                String key = headerItem.getAsJsonPrimitive("key").getAsString();
                String value = headerItem.getAsJsonPrimitive("value").getAsString();
                String description = ((JsonElement)headerItem.asMap().getOrDefault("description", new JsonPrimitive(""))).getAsJsonPrimitive().getAsString();
                boolean isDisabled = Boolean.parseBoolean(((JsonElement)headerItem.asMap().getOrDefault("disabled", new JsonPrimitive(Boolean.valueOf(false)))).getAsJsonPrimitive().getAsString());
                headers.add(new RequestHeader(key, value, description, isDisabled));
            }
        }
        return headers;
    }

    private String parseRequestUrl(JsonObject urlItem) {
        return urlItem.getAsJsonPrimitive("raw").getAsString().split("\\?")[0];
    }

    private List<RequestParam> parseRequestParameters(JsonObject urlItem) {
        ArrayList<RequestParam> parameters = new ArrayList<RequestParam>();
        if (urlItem.has("query")) {
            JsonArray paramsArray = urlItem.getAsJsonArray("query");
            for (Object parameter : paramsArray) {
                JsonObject paramItem = (JsonObject)parameter;
                String key = StringUtils.strip((String)((JsonElement)paramItem.asMap().getOrDefault("key", new JsonPrimitive(""))).toString(), (String)"\"");
                String value = StringUtils.strip((String)((JsonElement)paramItem.asMap().getOrDefault("value", new JsonPrimitive(""))).toString(), (String)"\"");
                String description = StringUtils.strip((String)((JsonElement)paramItem.asMap().getOrDefault("description", new JsonPrimitive(""))).toString(), (String)"\"");
                boolean isDisabled = Boolean.parseBoolean(((JsonElement)paramItem.asMap().getOrDefault("disabled", new JsonPrimitive(Boolean.valueOf(false)))).toString());
                parameters.add(new RequestParam(key, value, description, isDisabled));
            }
        }
        return parameters;
    }

    private List<ImportCollectionsResponse> parseRequestBody(RequestBody requestBody, JsonObject request, HttpRequest newRequest) {
        if (request.has("body")) {
            ArrayList<ImportCollectionsResponse> results = new ArrayList<ImportCollectionsResponse>();
            JsonObject body = request.getAsJsonObject("body");
            Pair<ImportCollectionsResponse, RequestBodyMode> result = this.parseRequestBodyMode(body);
            if (result.getLeft() != null) {
                results.add((ImportCollectionsResponse)result.getLeft());
                if (result.getRight() == null) {
                    return Arrays.asList((ImportCollectionsResponse)result.getLeft());
                }
            }
            this.parseRequestBodyType(requestBody, (RequestBodyMode)((Object)result.getRight()), body);
            results.addAll(this.parseRequestBodyContent(requestBody, (RequestBodyMode)((Object)result.getRight()), body, newRequest));
            return results;
        }
        return null;
    }

    private Pair<ImportCollectionsResponse, RequestBodyMode> parseRequestBodyMode(JsonObject bodyItem) {
        String bodyMode = bodyItem.getAsJsonPrimitive("mode").getAsString();
        RequestBodyMode mode = RequestBodyMode.valueOfIgnoreCase(bodyMode);
        if (mode == null) {
            log.info("Parse postman request failed: Unsupported data mode is used: {}", (Object)bodyMode);
            ImportCollectionsResponse result = new ImportCollectionsResponse();
            result.setComment("Unsupported data mode is used: " + bodyMode);
            result.setImportStatus(ImportCollectionStatus.ERROR);
            return Pair.of((Object)result, null);
        }
        if (RequestBodyMode.FILE.equals((Object)mode)) {
            log.info("Parse postman request failed: Data mode is FILE. The file must be uploaded separately.");
            ImportCollectionsResponse result = new ImportCollectionsResponse();
            result.setComment("Request was imported without a file.");
            result.setImportStatus(ImportCollectionStatus.WARNING);
            result.setErrorType(ImportCollectionError.BINARY_FILE_REQUIRED);
            return Pair.of((Object)result, (Object)((Object)mode));
        }
        return Pair.of(null, (Object)((Object)mode));
    }

    private void parseRequestBodyType(RequestBody body, RequestBodyMode bodyMode, JsonObject bodyItem) {
        RequestBodyType type = RequestBodyType.JSON;
        if (RequestBodyMode.RAW.equals((Object)bodyMode)) {
            try {
                String bodyTypeString = bodyItem.getAsJsonObject("options").getAsJsonObject("raw").getAsJsonPrimitive("language").getAsString();
                type = RequestBodyType.valueOfIgnoreCase(bodyTypeString);
            }
            catch (Exception e) {
                log.warn("Can't get extra constraints from 'options'", (Throwable)e);
            }
        } else if (RequestBodyMode.FORMDATA.equals((Object)bodyMode)) {
            type = RequestBodyType.FORM_DATA;
        } else if (RequestBodyMode.GRAPHQL.equals((Object)bodyMode)) {
            type = RequestBodyType.GraphQL;
        } else if (RequestBodyMode.FILE.equals((Object)bodyMode)) {
            type = RequestBodyType.Binary;
        }
        body.setType(type);
    }

    private List<ImportCollectionsResponse> parseRequestBodyContent(RequestBody body, RequestBodyMode bodyMode, JsonObject bodyItem, HttpRequest newRequest) {
        switch (bodyMode) {
            case URLENCODED: {
                body.setContent(this.parseRequestBodyUrlEncodedParams(bodyItem.getAsJsonArray("urlencoded")));
                this.addUrlEncodedHeader(newRequest);
                break;
            }
            case RAW: {
                body.setContent(bodyItem.getAsJsonPrimitive("raw").getAsString());
                break;
            }
            case GRAPHQL: {
                JsonObject graphQlObject = bodyItem.getAsJsonObject("graphql");
                body.setQuery(graphQlObject.getAsJsonPrimitive("query").getAsString());
                body.setVariables(graphQlObject.getAsJsonPrimitive("variables").getAsString());
                body.setContent(body.computeAndGetContent());
                break;
            }
            case FORMDATA: {
                Pair<List<FormDataPart>, List<ImportCollectionsResponse>> result = this.parseRequestBodyFormData(bodyItem.getAsJsonArray("formdata"));
                body.setType(RequestBodyType.FORM_DATA);
                body.setFormDataBody((List)result.getLeft());
                return (List)result.getRight();
            }
        }
        return new ArrayList<ImportCollectionsResponse>();
    }

    private void addUrlEncodedHeader(HttpRequest httpRequest) {
        if (httpRequest == null) {
            return;
        }
        if (httpRequest.getRequestHeaders() == null) {
            httpRequest.setRequestHeaders(new ArrayList<RequestHeader>());
        }
        if (httpRequest.getRequestHeaders().stream().noneMatch(header -> "Content-Type".equalsIgnoreCase(header.getKey()))) {
            httpRequest.getRequestHeaders().add(this.generateUrlEncodedHeader());
        }
    }

    private RequestHeader generateUrlEncodedHeader() {
        RequestHeader urlEncodedHeader = new RequestHeader();
        urlEncodedHeader.setDescription("");
        urlEncodedHeader.setDisabled(false);
        urlEncodedHeader.setKey("Content-Type");
        urlEncodedHeader.setValue("application/x-www-form-urlencoded");
        return urlEncodedHeader;
    }

    private String parseRequestBodyUrlEncodedParams(JsonArray values) {
        StringJoiner content = new StringJoiner("&");
        for (Object keyValue : values) {
            JsonObject kv = (JsonObject)keyValue;
            if (!kv.has("key")) continue;
            String key = kv.getAsJsonPrimitive("key").getAsString();
            String value = "";
            if (kv.has("value")) {
                value = kv.getAsJsonPrimitive("value").getAsString();
            }
            content.add(key + "=" + value);
        }
        return content.toString();
    }

    private Pair<List<FormDataPart>, List<ImportCollectionsResponse>> parseRequestBodyFormData(JsonArray values) {
        ArrayList<FormDataPart> formDataParts = new ArrayList<FormDataPart>();
        ArrayList<ImportCollectionsResponse> formDataParseResult = new ArrayList<ImportCollectionsResponse>();
        for (Object fdp : values) {
            JsonPrimitive disabledPrimitive;
            JsonPrimitive descriptionPrimitive;
            JsonObject fdpJson = (JsonObject)fdp;
            FormDataPart newFdp = new FormDataPart();
            newFdp.setId(UUID.randomUUID());
            JsonPrimitive keyPrimitive = fdpJson.getAsJsonPrimitive("key");
            if (Objects.nonNull(keyPrimitive)) {
                newFdp.setKey(keyPrimitive.getAsString());
            }
            ValueType vt = ValueType.valueOf(fdpJson.getAsJsonPrimitive("type").getAsString().toUpperCase());
            newFdp.setType(vt);
            JsonPrimitive contentTypePrimitive = fdpJson.getAsJsonPrimitive("contentType");
            if (Objects.nonNull(contentTypePrimitive)) {
                newFdp.setContentType(contentTypePrimitive.getAsString());
            }
            if (Objects.nonNull(descriptionPrimitive = fdpJson.getAsJsonPrimitive("description"))) {
                newFdp.setDescription(descriptionPrimitive.getAsString());
            }
            if (Objects.nonNull(disabledPrimitive = fdpJson.getAsJsonPrimitive("disabled"))) {
                newFdp.setDisabled(disabledPrimitive.getAsBoolean());
            }
            if (ValueType.TEXT.equals((Object)vt) || ValueType.DEFAULT.equals((Object)vt)) {
                JsonPrimitive valuePrimitive = fdpJson.getAsJsonPrimitive("value");
                if (Objects.nonNull(valuePrimitive)) {
                    newFdp.setValue(valuePrimitive.getAsString());
                }
            } else {
                JsonPrimitive scrPrimitive = null;
                JsonElement srcElement = fdpJson.get("src");
                if (Objects.nonNull(srcElement)) {
                    if (srcElement.isJsonArray()) {
                        JsonArray srcArray = srcElement.getAsJsonArray();
                        if (!srcArray.isEmpty()) {
                            scrPrimitive = srcArray.get(0).getAsJsonPrimitive();
                        }
                    } else {
                        scrPrimitive = fdpJson.getAsJsonPrimitive("src");
                    }
                }
                String fileName = "";
                if (Objects.nonNull(scrPrimitive)) {
                    fileName = FilenameUtils.getName((String)scrPrimitive.getAsString());
                }
                newFdp.setValue(fileName);
                ImportCollectionsResponse result = new ImportCollectionsResponse();
                result.setComment(String.format(REQUEST_WITHOUT_FILE_MESSAGE_FORMAT, fileName));
                result.setImportStatus(ImportCollectionStatus.WARNING);
                result.setErrorType(ImportCollectionError.FORMDATA_FILE_REQUIRED);
                result.setFormDataPartId(newFdp.getId());
                formDataParseResult.add(result);
            }
            formDataParts.add(newFdp);
        }
        return Pair.of(formDataParts, formDataParseResult);
    }

    private RequestAuthorization parseAuthorization(Folder parentFolder, JsonObject request) {
        if (request.has("auth")) {
            JsonObject auth = request.getAsJsonObject("auth");
            if (auth.has("type")) {
                Optional<RequestAuthorizationType> optionalRequestAuthorizationType = Arrays.stream(RequestAuthorizationType.values()).filter(authType -> authType.getName().equals(auth.getAsJsonPrimitive("type").getAsString().toUpperCase())).findFirst();
                if (!optionalRequestAuthorizationType.isPresent() || !auth.has(auth.getAsJsonPrimitive("type").getAsString())) {
                    return null;
                }
                JsonElement authByType = auth.get(auth.getAsJsonPrimitive("type").getAsString());
                if (Objects.nonNull(authByType)) {
                    Map<String, String> authorizationParametersMap = this.getAuthParametersAsMap(authByType);
                    return this.requestAuthorizationService.parseAuthorizationFromMap(authorizationParametersMap, optionalRequestAuthorizationType.get());
                }
            }
        } else {
            InheritFromParentRequestAuthorization requestAuth = new InheritFromParentRequestAuthorization();
            requestAuth.setType(RequestAuthorizationType.INHERIT_FROM_PARENT);
            if (Objects.nonNull(parentFolder)) {
                requestAuth.setAuthorizationFolderId(parentFolder.getId());
            }
            return requestAuth;
        }
        return null;
    }

    private Map<String, String> getAuthParametersAsMap(JsonElement auth) {
        HashMap<String, String> authorizationParametersMap;
        block4: {
            block3: {
                authorizationParametersMap = new HashMap<String, String>();
                if (!auth.isJsonObject()) break block3;
                Map kvMap = auth.getAsJsonObject().asMap();
                if (CollectionUtils.isEmpty((Map)kvMap)) break block4;
                for (Map.Entry keyValue : kvMap.entrySet()) {
                    String key = (String)keyValue.getKey();
                    JsonPrimitive value = ((JsonElement)keyValue.getValue()).getAsJsonPrimitive();
                    if (!Objects.nonNull(key) || !Objects.nonNull(value)) continue;
                    authorizationParametersMap.put(key, value.getAsString());
                }
                break block4;
            }
            if (auth.isJsonArray()) {
                for (Object keyValue : auth.getAsJsonArray()) {
                    JsonObject kv = (JsonObject)keyValue;
                    JsonPrimitive key = kv.getAsJsonPrimitive("key");
                    JsonPrimitive value = kv.getAsJsonPrimitive("value");
                    if (!Objects.nonNull(key) || !Objects.nonNull(value)) continue;
                    authorizationParametersMap.put(key.getAsString(), value.getAsString());
                }
            }
        }
        return authorizationParametersMap;
    }

    public List<UUID> executeCollection(String authToken, CollectionExecuteRequest request) {
        UUID projectId = request.getProjectId();
        UUID defaultTestPlanId = this.ramService.getDefaultCollectionRunTestPlanId(projectId);
        EnrichedScenarioDto testScenario = this.generateIftLiteRunCollectionScenario(request);
        ExecuteRequestDto executeRequestDto = new ExecuteRequestDto().name(request.getName()).environmentIds(request.getEnvironmentIds()).emailRecipients(request.getEmailRecipients()).emailTemplateId(request.getEmailTemplateId()).emailSubject(request.getEmailSubject()).taToolIds(request.getTaToolIds()).flags(request.getFlags().stream().map(flag -> ExecuteRequestDto.FlagsEnum.valueOf(flag.name())).collect(Collectors.toList())).logCollectorTemplateId(request.getLogCollectorTemplateId()).projectId(request.getProjectId()).testPlanId(defaultTestPlanId).threadCount(1).isMandatoryCheck(request.isMandatoryCheck()).isSsmCheck(request.isSsmCheck()).isIgnoreFailedChecks(request.isIgnoreFailedChecks()).testScenarios(Collections.singletonList(testScenario)).dataSetStorageId(request.getDataSetStorageId()).datasetId(request.getDataSetId()).contextVariables(request.convertContextVariablesToMap());
        List<UUID> listExecutedId = this.catalogueService.execute(authToken, executeRequestDto);
        if (request.isPropagateCookies() && !CollectionUtils.isEmpty(listExecutedId)) {
            log.info("Propagating cookies in collection execution enabled. ErId: {}", listExecutedId);
            this.copyCookiesForCollectionExecution(projectId, listExecutedId.get(0));
        }
        this.metricService.registerCountRunCollections(projectId);
        log.debug("List collection executed id: {}", listExecutedId);
        return listExecutedId;
    }

    private void copyCookiesForCollectionExecution(UUID projectId, UUID erId) {
        List<Cookie> cookies = this.cookieService.getNotExpiredCookiesByUserIdAndProjectId(projectId);
        cookies.forEach(cookie -> cookie.setUserId(null));
        this.cookieService.fillCookieInfoWithExecutionRequestInfo(cookies, erId, null);
        this.cookieService.save(cookies);
    }

    private EnrichedScenarioDto generateIftLiteRunCollectionScenario(CollectionExecuteRequest request) {
        List<EnrichedCompoundDto> compounds = this.generateCompounds(request);
        EnrichedScenarioDto testScenario = new EnrichedScenarioDto();
        testScenario.setTestScenarioId(UUID.randomUUID());
        testScenario.setTestScenarioName(request.getName());
        testScenario.setCompounds(compounds);
        return testScenario;
    }

    private List<EnrichedCompoundDto> generateCompounds(CollectionExecuteRequest request) {
        UUID environmentId = StreamUtils.getFirstElem(request.getEnvironmentIds());
        DirectiveDto directive = this.getExecutionDirective(environmentId);
        List<GroupResponse> treeNodes = request.getTreeNodes();
        return treeNodes.stream().map(node -> this.mapItfLiteTreeNodeToCompound((GroupResponse)node, directive, request.getProjectId())).collect(Collectors.toList());
    }

    private EnrichedCompoundDto mapItfLiteTreeNodeToCompound(GroupResponse node, DirectiveDto directive, UUID projectId) {
        EnrichedCompoundDto enrichedCompound = new EnrichedCompoundDto();
        enrichedCompound.setDirectives(Collections.singletonList(directive));
        EntityType type = node.getType();
        if (type.equals((Object)EntityType.FOLDER)) {
            enrichedCompound.setId(UUID.randomUUID());
            enrichedCompound.setContent(node.getName());
            enrichedCompound.setType(TypeEnum.valueOf(AbstractTestScenario.Type.COMPOUND.name()));
            List<GroupResponse> children = node.getChildren();
            if (!CollectionUtils.isEmpty(children)) {
                List<EnrichedCompoundDto> childrenEnrichedCompounds = children.stream().map(childNode -> this.mapItfLiteTreeNodeToCompound((GroupResponse)childNode, directive, projectId)).collect(Collectors.toList());
                enrichedCompound.setChildCompounds(childrenEnrichedCompounds);
            }
        } else {
            String requestId = node.getId().toString();
            String actionName = "Execute request \"uuid\"";
            enrichedCompound.setContent("Execute request \"uuid\"");
            enrichedCompound.setEntity(new ActionEntityDto().name("Execute request \"uuid\"").parameters(Collections.singletonList(new ActionParameterDto().name("uuid").value(requestId))));
            this.metricService.registerCountCollectionRequests(projectId);
        }
        return enrichedCompound;
    }

    private DirectiveDto getExecutionDirective(UUID environmentId) {
        System firstEnvironmentSystem = this.getFirstEnvironmentSystem(environmentId);
        DirectiveDto directive = new DirectiveDto();
        directive.setName(DirectiveEnum.USE.getName());
        directive.putParametersItem(Directive.DirectiveParameter.VALUE.name(), firstEnvironmentSystem.getName());
        return directive;
    }

    private System getFirstEnvironmentSystem(UUID environmentId) {
        List<System> environmentSystems = this.environmentService.getEnvironmentSystems(environmentId);
        return StreamUtils.getFirstElem(environmentSystems);
    }

    void processContentTypeHeader(List<RequestHeader> requestHeaders, RequestBody requestBody) {
        List contentTypeHeaders = requestHeaders.stream().filter(header -> "Content-Type".equals(header.getKey())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(contentTypeHeaders)) {
            RequestBodyType bodyType = requestBody.getType();
            if (Objects.nonNull((Object)bodyType)) {
                String bodyContentTypeValue = null;
                if (Objects.nonNull(bodyType.getContentTypes())) {
                    bodyContentTypeValue = bodyType.getContentTypes().get(0);
                }
                RequestHeader contentTypeHeader = new RequestHeader("Content-Type", bodyContentTypeValue, "", false, true);
                requestHeaders.add(contentTypeHeader);
            }
        } else {
            boolean isEnabledUserContentTypeHeaderPresent = contentTypeHeaders.stream().anyMatch(header -> !header.isDisabled() && !header.isGenerated());
            if (isEnabledUserContentTypeHeaderPresent) {
                contentTypeHeaders.stream().filter(RequestHeader::isGenerated).forEach(header -> header.setDisabled(true));
            }
        }
    }

    public CollectionsService(FolderService folderService, RequestService requestService, RequestAuthorizationService requestAuthorizationService, EnvironmentFeignService environmentService, RamService ramService, CatalogueService catalogueService, MetricService metricService, DynamicVariablesService dynamicVariablesService, CookieService cookieService) {
        this.folderService = folderService;
        this.requestService = requestService;
        this.requestAuthorizationService = requestAuthorizationService;
        this.environmentService = environmentService;
        this.ramService = ramService;
        this.catalogueService = catalogueService;
        this.metricService = metricService;
        this.dynamicVariablesService = dynamicVariablesService;
        this.cookieService = cookieService;
    }
}

