/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.itf.lite.backend.model.api.request.IdWithModifiedWhen;
import org.qubership.atp.itf.lite.backend.model.entities.AbstractNamedEntity;
import org.qubership.atp.itf.lite.backend.model.entities.Folder;
import org.qubership.atp.itf.lite.backend.model.entities.Request;
import org.qubership.atp.itf.lite.backend.service.CrudService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ConcurrentModificationService {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentModificationService.class);

    public <T> Boolean isModifyDateChanging(T modifyDateFromRequest, T modifyDateFromMongo) {
        return modifyDateFromRequest != null && !modifyDateFromRequest.equals(modifyDateFromMongo);
    }

    public <T extends AbstractNamedEntity> HttpStatus getConcurrentModificationHttpStatus(UUID entityId, Date modifyDateFromRequest, CrudService<T> service, Boolean skipTypeCheck) {
        AbstractNamedEntity entity = (AbstractNamedEntity)service.get(entityId);
        Boolean isConcurrentModification = this.isModifyDateChanging(modifyDateFromRequest, entity.getModifiedWhen());
        if (Boolean.TRUE.equals(isConcurrentModification)) {
            return !(skipTypeCheck != null && !Boolean.FALSE.equals(skipTypeCheck) || !(entity instanceof Folder) && !(entity instanceof Request)) ? HttpStatus.CONFLICT : HttpStatus.IM_USED;
        }
        return HttpStatus.OK;
    }

    public <T extends AbstractNamedEntity> HttpStatus getConcurrentModificationHttpStatus(UUID entityId, Date modifyDateFromRequest, CrudService<T> service) {
        return this.getConcurrentModificationHttpStatus(entityId, modifyDateFromRequest, service, false);
    }

    public <T extends AbstractNamedEntity> Pair<HttpStatus, List<UUID>> getConcurrentModificationHttpStatus(Collection<IdWithModifiedWhen> entityIds, CrudService<T> service) {
        HttpStatus status = HttpStatus.OK;
        ArrayList<UUID> concurrentModification = new ArrayList<UUID>();
        if (!CollectionUtils.isEmpty(entityIds)) {
            for (IdWithModifiedWhen id : entityIds) {
                HttpStatus res = this.getConcurrentModificationHttpStatus(id.getId(), id.getModifiedWhen(), service, false);
                if (HttpStatus.OK.equals((Object)res)) continue;
                status = res;
                concurrentModification.add(id.getId());
            }
        }
        return Pair.of((Object)status, concurrentModification);
    }
}

