/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import clover.org.apache.commons.lang.StringUtils;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.CookiesRepository;
import org.qubership.atp.itf.lite.backend.exceptions.cookie.IllegalCookieException;
import org.qubership.atp.itf.lite.backend.exceptions.requests.ItfLiteUrlSyntaxException;
import org.qubership.atp.itf.lite.backend.feign.service.RamService;
import org.qubership.atp.itf.lite.backend.model.api.request.ImportFromRamRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.http.HttpHeaderSaveRequest;
import org.qubership.atp.itf.lite.backend.model.entities.Cookie;
import org.qubership.atp.itf.lite.backend.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CookieService {
    private static final Logger log = LoggerFactory.getLogger(CookieService.class);
    private final CookiesRepository cookiesRepository;
    private final Provider<UserInfo> userInfoProvider;
    private final RamService ramService;

    @Transactional
    public List<Cookie> getNotExpiredCookiesByUserIdAndProjectId(UUID projectId) {
        List<Cookie> cookies = this.cookiesRepository.findAllByUserIdAndProjectId(((UserInfo)this.userInfoProvider.get()).getId(), projectId);
        List<Cookie> filteredCookies = this.filterExpired(cookies);
        cookies.removeAll(filteredCookies);
        this.cookiesRepository.removeAllByIdIn(StreamUtils.extractIds(cookies));
        return filteredCookies;
    }

    @Transactional
    public List<Cookie> save(List<Cookie> cookies) {
        cookies = this.filterExpired(cookies);
        return this.cookiesRepository.saveAll(cookies);
    }

    @Transactional
    public void deleteByUserIdAndProjectId(UUID projectId) {
        this.cookiesRepository.removeAllByUserIdAndProjectId(((UserInfo)this.userInfoProvider.get()).getId(), projectId);
    }

    @Transactional
    public void deleteByExecutionRequestIdAndTestRunId(UUID executionRequestId, UUID testRunId) {
        this.cookiesRepository.removeAllByExecutionRequestIdAndTestRunId(executionRequestId, testRunId);
    }

    private List<Cookie> filterExpired(List<Cookie> cookies) {
        try {
            Map parsedCookies = cookies.stream().flatMap(cookie -> {
                try {
                    return HttpCookie.parse(cookie.getValue()).stream().peek(c -> c.setDomain(cookie.getDomain()));
                }
                catch (IllegalArgumentException ex) {
                    log.error("Failed to parse cookie: {}", (Object)cookie.getKey());
                    throw new IllegalCookieException(ex.getMessage());
                }
            }).filter(cookie -> !cookie.hasExpired()).collect(Collectors.toMap(this::getNameWithDomain, Function.identity()));
            return cookies.stream().filter(cookie -> parsedCookies.containsKey(this.getNameWithDomain((Cookie)cookie))).collect(Collectors.toList());
        }
        catch (IllegalStateException ex) {
            log.error("Cookie name is duplicated", (Throwable)ex);
            throw new IllegalCookieException("The cookie name must be unique within the same domain");
        }
    }

    private String getNameWithDomain(HttpCookie cookie) {
        return cookie.getName() + "-" + cookie.getDomain();
    }

    private String getNameWithDomain(Cookie cookie) {
        return cookie.getKey() + "-" + cookie.getDomain();
    }

    public void fillCookieInfo(List<Cookie> cookies, UUID projectId) {
        cookies.forEach(cookie -> {
            cookie.setProjectId(projectId);
            cookie.setUserId(((UserInfo)this.userInfoProvider.get()).getId());
        });
    }

    public void fillCookieInfoWithExecutionRequestInfo(List<Cookie> cookies, UUID executionRequestId, UUID testRunId) {
        cookies.forEach(cookie -> {
            cookie.setExecutionRequestId(executionRequestId);
            cookie.setTestRunId(testRunId);
        });
    }

    public List<Cookie> getAllByExecutionRequestIdAndTestRunId(UUID executionRequestId, UUID testRunId) {
        return this.filterExpired(this.cookiesRepository.findAllByExecutionRequestIdAndTestRunIdOrTestRunIdIsNull(executionRequestId, testRunId));
    }

    public HttpHeaderSaveRequest cookieListToRequestHeader(String url, List<Cookie> cookies) {
        try {
            return this.cookieListToRequestHeader(new URI(url), cookies);
        }
        catch (URISyntaxException ex) {
            log.error("Failed to parse url", (Throwable)ex);
            throw new ItfLiteUrlSyntaxException(ex.getMessage());
        }
    }

    public HttpHeaderSaveRequest cookieListToRequestHeader(URI uri, List<Cookie> cookies) {
        return new HttpHeaderSaveRequest("Cookie", this.cookiesToString(uri, cookies));
    }

    public List<Cookie> filterCookie(String url, List<Cookie> cookies) {
        try {
            URI uri = new URI(url);
            return this.filterCookie(uri, cookies);
        }
        catch (URISyntaxException ex) {
            log.error("Failed to parse url", (Throwable)ex);
            throw new ItfLiteUrlSyntaxException(ex.getMessage());
        }
    }

    public List<Cookie> filterCookie(URI uri, List<Cookie> cookies) {
        return cookies.stream().filter(cookie -> {
            List<HttpCookie> parsedCookies;
            if (!cookie.isDisabled() && !CollectionUtils.isEmpty(parsedCookies = HttpCookie.parse(cookie.getValue()))) {
                for (HttpCookie parsedCookie : parsedCookies) {
                    if (StringUtils.isEmpty((String)parsedCookie.getDomain())) {
                        parsedCookie.setDomain(cookie.getDomain());
                    }
                    if (this.filterCookieForUri(uri, parsedCookie)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }).collect(Collectors.toList());
    }

    public String cookiesToString(URI uri, List<Cookie> cookies) {
        CookieManager cookieManager = new CookieManager();
        cookies.forEach(cookie -> {
            List<HttpCookie> parsedCookies = HttpCookie.parse(cookie.getValue());
            if (!cookie.isDisabled() && !CollectionUtils.isEmpty(parsedCookies)) {
                parsedCookies.forEach(parsedCookie -> {
                    if (StringUtils.isEmpty((String)parsedCookie.getDomain())) {
                        parsedCookie.setDomain(cookie.getDomain());
                    }
                    if (this.filterCookieForUri(uri, (HttpCookie)parsedCookie)) {
                        cookieManager.getCookieStore().add(null, (HttpCookie)parsedCookie);
                    }
                });
            }
        });
        return StringUtils.join(cookieManager.getCookieStore().getCookies(), (String)";");
    }

    private boolean filterCookieForUri(URI uri, HttpCookie cookie) {
        if (cookie.hasExpired()) {
            return false;
        }
        if (!StringUtils.isEmpty((String)cookie.getDomain()) && !HttpCookie.domainMatches(cookie.getDomain(), uri.getHost())) {
            return false;
        }
        if (!this.pathMatches(cookie.getPath(), uri.getRawPath())) {
            return false;
        }
        String scheme = uri.getScheme();
        if (cookie.isHttpOnly() && !"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) {
            return false;
        }
        return !cookie.getSecure() || "https".equalsIgnoreCase(uri.getScheme());
    }

    private boolean pathMatches(String cookiePath, String requestPath) {
        if (StringUtils.isEmpty((String)cookiePath) || "/".equals(cookiePath)) {
            return true;
        }
        cookiePath = cookiePath.toLowerCase();
        requestPath = requestPath.toLowerCase();
        if (cookiePath.endsWith("/")) {
            return requestPath.startsWith(cookiePath);
        }
        return requestPath.equals(cookiePath);
    }

    @Transactional
    public void deleteIfErIdOrTrIdSpecified() {
        this.cookiesRepository.removeAllByExecutionRequestIdIsNotNullAndTestRunIdIsNotNull();
    }

    @Transactional
    public void deleteAllByIdIn(Collection<UUID> ids) {
        this.cookiesRepository.removeAllByIdIn(ids);
    }

    public List<Cookie> getAll() {
        return this.cookiesRepository.findAll();
    }

    @Transactional
    public List<Cookie> importCookiesFromRam(UUID projectId, ImportFromRamRequest importRequest) {
        List<Cookie> importedCookies = this.ramService.importCookies(importRequest);
        List<Cookie> savedCookie = this.getNotExpiredCookiesByUserIdAndProjectId(projectId);
        if (CollectionUtils.isEmpty(importedCookies)) {
            return savedCookie;
        }
        Map<String, List<Cookie>> mappedImportedCookies = importedCookies.stream().collect(Collectors.groupingBy(this::getNameWithDomain));
        Map mappedSavedCookies = savedCookie.stream().collect(Collectors.toMap(this::getNameWithDomain, Function.identity()));
        mappedImportedCookies.forEach((k, v) -> {
            int lastIndex = v.size() - 1;
            mappedSavedCookies.put((String)k, (Cookie)v.get(lastIndex));
        });
        return this.filterExpired(new ArrayList<Cookie>(mappedSavedCookies.values()));
    }

    public CookieService(CookiesRepository cookiesRepository, Provider<UserInfo> userInfoProvider, RamService ramService) {
        this.cookiesRepository = cookiesRepository;
        this.userInfoProvider = userInfoProvider;
        this.ramService = ramService;
    }
}

