/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.modelmapper.ModelMapper;
import org.qubership.atp.itf.lite.backend.enums.EntityType;
import org.qubership.atp.itf.lite.backend.model.api.request.FolderTreeSearchRequest;
import org.qubership.atp.itf.lite.backend.model.api.response.GroupResponse;
import org.qubership.atp.itf.lite.backend.model.documentation.AbstractDocumentation;
import org.qubership.atp.itf.lite.backend.model.documentation.DocumentationResponse;
import org.qubership.atp.itf.lite.backend.model.documentation.FolderDocumentation;
import org.qubership.atp.itf.lite.backend.model.documentation.RequestDocumentation;
import org.qubership.atp.itf.lite.backend.model.documentation.RequestEntityEditDocumentation;
import org.qubership.atp.itf.lite.backend.model.documentation.TreeFolderDocumentationResponse;
import org.qubership.atp.itf.lite.backend.model.entities.Folder;
import org.qubership.atp.itf.lite.backend.model.entities.Request;
import org.qubership.atp.itf.lite.backend.service.FolderService;
import org.qubership.atp.itf.lite.backend.service.RequestService;
import org.qubership.atp.itf.lite.backend.service.WritePermissionsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DocumentationService {
    private static final Logger log = LoggerFactory.getLogger(DocumentationService.class);
    private final FolderService folderService;
    private final RequestService requestService;
    private final ModelMapper modelMapper;
    private final WritePermissionsService writePermissionsService;

    public TreeFolderDocumentationResponse getDescription(FolderTreeSearchRequest request, int page, int pageSize) {
        UUID projectId = request.getProjectId();
        UUID parentId = request.getParentId();
        log.debug("Collect description for folder and request. Project {} for parent folder {}", (Object)projectId, (Object)parentId);
        GroupResponse sortedDoc = this.folderService.getRequestTreeByParentFolderId(parentId);
        ArrayList<DocumentationResponse> listGroupResponse = new ArrayList<DocumentationResponse>();
        this.convertToListGroupResponse(listGroupResponse, sortedDoc);
        int size = listGroupResponse.size();
        List<DocumentationResponse> listOfPartDocumentation = this.getPartOfObject(listGroupResponse, page, size, pageSize);
        ArrayList<AbstractDocumentation> abstractDocumentationList = new ArrayList<AbstractDocumentation>();
        listOfPartDocumentation.stream().forEach(obj -> {
            if (EntityType.FOLDER.equals((Object)obj.getType())) {
                Folder temporaryFolder = this.folderService.getFolder(obj.getId());
                FolderDocumentation folderDocumentation = (FolderDocumentation)this.modelMapper.map((Object)temporaryFolder, FolderDocumentation.class);
                folderDocumentation.setHasWritePermissions(this.writePermissionsService.hasWritePermissions(temporaryFolder.getPermissionFolderId(), temporaryFolder.getProjectId()));
                abstractDocumentationList.add(folderDocumentation);
            } else if (EntityType.REQUEST.equals((Object)obj.getType())) {
                Request temporaryRequest = this.requestService.getRequest(obj.getId());
                abstractDocumentationList.add((AbstractDocumentation)this.modelMapper.map((Object)temporaryRequest, RequestDocumentation.class));
            }
        });
        return new TreeFolderDocumentationResponse(size, abstractDocumentationList);
    }

    public RequestDocumentation editDocumentationRequest(UUID requestId, RequestEntityEditDocumentation documentationRequest) {
        log.debug("Check if request with requestId {} exists in project {}", (Object)requestId, (Object)documentationRequest.getProjectId());
        Request temporaryRequest = this.requestService.getRequest(requestId);
        temporaryRequest.setDescription(documentationRequest.getDescription());
        temporaryRequest = this.requestService.save(temporaryRequest);
        RequestDocumentation requestDocumentation = (RequestDocumentation)this.modelMapper.map((Object)temporaryRequest, RequestDocumentation.class);
        log.debug("Edited documentation for Request {}", (Object)requestDocumentation);
        return requestDocumentation;
    }

    public FolderDocumentation editDocumentationFolder(UUID folderId, RequestEntityEditDocumentation documentationRequest) {
        log.debug("Check if request with requestId {} exists in project {}", (Object)folderId, (Object)documentationRequest.getProjectId());
        Folder temporaryFolder = this.folderService.getFolder(folderId);
        this.modelMapper.map((Object)documentationRequest, (Object)temporaryFolder);
        temporaryFolder = this.folderService.save(temporaryFolder);
        FolderDocumentation folderDocumentation = (FolderDocumentation)this.modelMapper.map((Object)temporaryFolder, FolderDocumentation.class);
        log.debug("Edited documentation for Folder {}", (Object)folderDocumentation);
        return folderDocumentation;
    }

    private List<DocumentationResponse> getPartOfObject(List<DocumentationResponse> listDocumentation, int page, int size, int pageSize) {
        if (size > pageSize) {
            List<DocumentationResponse> listOfPartDocumentation = listDocumentation.subList(Math.min(listDocumentation.size() - 1, page * pageSize), Math.min(listDocumentation.size(), page * pageSize + pageSize));
            return listOfPartDocumentation;
        }
        return listDocumentation;
    }

    private List<DocumentationResponse> convertToListGroupResponse(List<DocumentationResponse> list, GroupResponse tree) {
        list.add((DocumentationResponse)this.modelMapper.map((Object)tree, DocumentationResponse.class));
        if (tree.getChildren() != null) {
            tree.getChildren().forEach(child -> this.convertToListGroupResponse(list, (GroupResponse)child));
        }
        return list;
    }

    public DocumentationService(FolderService folderService, RequestService requestService, ModelMapper modelMapper, WritePermissionsService writePermissionsService) {
        this.folderService = folderService;
        this.requestService = requestService;
        this.modelMapper = modelMapper;
        this.writePermissionsService = writePermissionsService;
    }
}

