/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qubership.atp.itf.lite.backend.model.entities.http.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DynamicVariablesService {
    private static final Logger log = LoggerFactory.getLogger(DynamicVariablesService.class);
    static final String PRE_SCRIPT_TEMPLATE = "pm.variables.set('%s', pm.variables.replaceIn('%s'));";
    private static final Pattern patternVariables = Pattern.compile("\\{\\{\\$.*?\\}\\}");

    public HttpRequest enrichPreScriptsByDynamicVariables(HttpRequest httpRequest) {
        Set<String> dynamicVariables = DynamicVariablesService.getDynamicVariables(httpRequest.getPreScripts(), httpRequest.getUrl(), httpRequest.getRequestParams() != null ? Arrays.toString(httpRequest.getRequestParams().toArray()) : "", httpRequest.getRequestHeaders() != null ? Arrays.toString(httpRequest.getRequestHeaders().toArray()) : "", httpRequest.getBody() != null ? httpRequest.getBody().getContent() : "", httpRequest.getBody() != null ? httpRequest.getBody().getQuery() : "", httpRequest.getBody() != null ? httpRequest.getBody().getVariables() : "", String.valueOf(httpRequest.getAuthorization()));
        httpRequest.setPreScripts(this.insertDynamicVariablesIntoPreScripts(httpRequest.getPreScripts(), dynamicVariables));
        return httpRequest;
    }

    public String insertDynamicVariablesIntoPreScripts(String preScript, Set<String> dynamicVariables) {
        StringBuffer stringBuffer = new StringBuffer();
        if (preScript == null) {
            preScript = "";
        }
        if (dynamicVariables != null) {
            for (String variable : dynamicVariables) {
                String temporary = String.format(PRE_SCRIPT_TEMPLATE, variable.replaceAll("\\{\\{", "").replaceAll("\\}\\}", ""), variable);
                if (preScript.contains(temporary)) continue;
                stringBuffer.append(temporary + "\r\n");
            }
        }
        stringBuffer.append(preScript);
        return stringBuffer.toString();
    }

    public static Set<String> getDynamicVariables(String ... anyStrings) {
        HashSet<String> dynamicVariables = new HashSet<String>();
        for (String str : anyStrings) {
            Matcher matcher = patternVariables.matcher(String.valueOf(str));
            while (matcher.find()) {
                dynamicVariables.add(matcher.group(0));
            }
        }
        return dynamicVariables;
    }
}

