/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.UUID;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import org.qubership.atp.itf.lite.backend.model.entities.Folder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class FolderSpecificationService {
    private static final Logger log = LoggerFactory.getLogger(FolderSpecificationService.class);
    private final String folderProjectIdFieldName = "projectId";
    private final String folderParentIdFieldName = "parentId";

    public Specification<Folder> generateSpecificationToFilterFoldersByProjectIdAndParentFolderId(UUID projectId, UUID parentFolderId) {
        return (Specification & Serializable)(root, query, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (projectId != null) {
                predicates.add(builder.equal((Expression)root.get("projectId"), (Object)projectId));
            }
            if (parentFolderId != null) {
                predicates.add(builder.equal((Expression)root.get("parentId"), (Object)parentFolderId));
            }
            if (predicates.isEmpty()) {
                return builder.conjunction();
            }
            query.orderBy(new Order[]{builder.asc((Expression)root.get("order"))});
            return builder.and(predicates.toArray(new Predicate[0]));
        };
    }
}

