/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import com.google.common.base.Strings;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpException;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.qubership.atp.auth.springbootstarter.utils.ExceptionUtils;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.GetAuthorizationCodeRepository;
import org.qubership.atp.itf.lite.backend.exceptions.auth.AuthActionDuplicateSseException;
import org.qubership.atp.itf.lite.backend.exceptions.auth.AuthActionGetTokenByCodeException;
import org.qubership.atp.itf.lite.backend.exceptions.auth.AuthActionInvalidSseException;
import org.qubership.atp.itf.lite.backend.exceptions.auth.AuthActionMandatoryFieldException;
import org.qubership.atp.itf.lite.backend.feign.dto.GetAccessCodeParametersDto;
import org.qubership.atp.itf.lite.backend.mdc.ItfLiteMdcField;
import org.qubership.atp.itf.lite.backend.model.entities.auth.GetAuthorizationCode;
import org.qubership.atp.itf.lite.backend.service.EncryptionService;
import org.qubership.atp.itf.lite.backend.service.kafka.KafkaGetAccessTokenService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GetAccessTokenByCodeService {
    private static final Logger log = LoggerFactory.getLogger(GetAccessTokenByCodeService.class);
    private final GetAuthorizationCodeRepository getAuthorizationCodeRepository;
    private final Provider<UserInfo> userInfoProvider;
    private final EncryptionService encryptionService;
    private final KafkaGetAccessTokenService kafkaGetAccessTokenService;

    public void saveCode(UUID sseId, String authorizationCode, String state) {
        Optional getAuthorizationCodeOptional;
        if (Strings.isNullOrEmpty((String)authorizationCode)) {
            ExceptionUtils.throwWithLog((Logger)log, (AtpException)new AuthActionMandatoryFieldException("'" + authorizationCode + "'"));
        }
        if (!(getAuthorizationCodeOptional = this.getAuthorizationCodeRepository.findById(sseId)).isPresent()) {
            ExceptionUtils.throwWithLog((Logger)log, (AtpException)new AuthActionInvalidSseException(sseId));
        }
        MdcUtils.put((String)ItfLiteMdcField.SSE_ID.toString(), (UUID)sseId);
        GetAuthorizationCode getAuthorizationCode = (GetAuthorizationCode)getAuthorizationCodeOptional.get();
        try {
            getAuthorizationCode.setAuthorizationCode(this.encryptionService.encrypt(authorizationCode));
            getAuthorizationCode.setResponseState(state);
            this.getAuthorizationCodeRepository.save(getAuthorizationCode);
            this.kafkaGetAccessTokenService.getAccessTokenFinishEventSend(sseId);
        }
        catch (Exception e) {
            ExceptionUtils.throwWithLog((Logger)log, (AtpException)new AuthActionGetTokenByCodeException(e.getMessage()));
        }
    }

    public void saveParamsForGetAccessCode(GetAccessCodeParametersDto getAccessCodeParametersDto) {
        ArrayList<String> looseMandatoryFields = new ArrayList<String>();
        if (getAccessCodeParametersDto.getSseId() == null) {
            looseMandatoryFields.add("sseId");
        }
        if (Strings.isNullOrEmpty((String)getAccessCodeParametersDto.getAccessTokenUrl())) {
            looseMandatoryFields.add("accessTokenUrl");
        }
        if (Strings.isNullOrEmpty((String)getAccessCodeParametersDto.getClientId())) {
            looseMandatoryFields.add("clientId");
        }
        if (Strings.isNullOrEmpty((String)getAccessCodeParametersDto.getClientSecret())) {
            looseMandatoryFields.add("clientSecret");
        }
        if (Strings.isNullOrEmpty((String)getAccessCodeParametersDto.getRedirectUri())) {
            looseMandatoryFields.add("redirectUri");
        }
        if (looseMandatoryFields.size() > 0) {
            ExceptionUtils.throwWithLog((Logger)log, (AtpException)new AuthActionMandatoryFieldException(((Object)looseMandatoryFields).toString()));
        }
        if (this.getAuthorizationCodeRepository.findById(getAccessCodeParametersDto.getSseId()).isPresent()) {
            ExceptionUtils.throwWithLog((Logger)log, (AtpException)new AuthActionDuplicateSseException(getAccessCodeParametersDto.getSseId()));
        }
        try {
            MdcUtils.put((String)ItfLiteMdcField.SSE_ID.toString(), (UUID)getAccessCodeParametersDto.getSseId());
            String user = this.userInfoProvider != null && this.userInfoProvider.get() != null ? ((UserInfo)this.userInfoProvider.get()).getUsername() : "UserNotDefined";
            log.info("save authorization parameters into DB for sseID {}", (Object)getAccessCodeParametersDto.getSseId());
            String clientId = getAccessCodeParametersDto.getClientId();
            String clientSecret = this.decodeParameter(getAccessCodeParametersDto.getClientSecret());
            this.getAuthorizationCodeRepository.save(new GetAuthorizationCode(getAccessCodeParametersDto.getSseId(), getAccessCodeParametersDto.getProjectId(), Timestamp.from(Instant.now()), getAccessCodeParametersDto.getAccessTokenUrl(), clientId, this.encryptionService.isEncrypted(clientSecret) ? clientSecret : this.encryptionService.encrypt(clientSecret), getAccessCodeParametersDto.getScope(), getAccessCodeParametersDto.getState(), getAccessCodeParametersDto.getRedirectUri(), null, user, null, null));
        }
        catch (Exception e) {
            ExceptionUtils.throwWithLog((Logger)log, (AtpException)new AuthActionGetTokenByCodeException(e.getMessage()));
        }
    }

    private String decodeParameter(String paramValue) {
        if (Objects.nonNull(paramValue) && paramValue.startsWith("{2ENC}")) {
            paramValue = paramValue.replace("{2ENC}", "");
            paramValue = this.encryptionService.decodeBase64(paramValue);
        }
        return paramValue;
    }

    public GetAccessTokenByCodeService(GetAuthorizationCodeRepository getAuthorizationCodeRepository, Provider<UserInfo> userInfoProvider, EncryptionService encryptionService, KafkaGetAccessTokenService kafkaGetAccessTokenService) {
        this.getAuthorizationCodeRepository = getAuthorizationCodeRepository;
        this.userInfoProvider = userInfoProvider;
        this.encryptionService = encryptionService;
        this.kafkaGetAccessTokenService = kafkaGetAccessTokenService;
    }
}

