/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.IOUtils;
import org.apache.tika.Tika;
import org.qubership.atp.itf.lite.backend.components.replacer.ContextVariablesReplacer;
import org.qubership.atp.itf.lite.backend.model.context.SaveRequestResolvingContext;
import org.qubership.atp.itf.lite.backend.model.entities.FileBody;
import org.qubership.atp.itf.lite.backend.model.entities.gridfs.FileData;
import org.qubership.atp.itf.lite.backend.service.GridFsService;
import org.qubership.atp.itf.lite.backend.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Service
public class ItfLiteFileService {
    private static final Logger log = LoggerFactory.getLogger(ItfLiteFileService.class);
    private final GridFsService gridFsService;
    private final ContextVariablesReplacer replacer;
    private final Tika fileDetector = new Tika();
    @Value(value="${atp.itf.lite.clean.file.cache.time-sec:3600}")
    private String cleanFileCacheTimeout;

    public FileData getRequestFileData(UUID requestId, Date modifiedWhen, Path folder) throws IOException {
        Optional<Path> requestFilePath = this.getPathToFile(requestId, modifiedWhen, folder);
        if (requestFilePath.isPresent()) {
            Path path = requestFilePath.get();
            String type = this.fileDetector.detect(path);
            return new FileData(Files.readAllBytes(path), path.getFileName().toString(), type);
        }
        Optional<FileData> fileDataOptional = this.gridFsService.downloadFile(requestId);
        if (fileDataOptional.isPresent()) {
            FileData fileData = fileDataOptional.get();
            FileUtils.saveFileDataDictionaryToFileSystem(folder, requestId, fileData);
            return fileData;
        }
        return null;
    }

    public FileData getFileDataById(UUID fileId, Date modifiedWhen, Path folder) throws IOException {
        Optional<Path> requestFilePath = this.getRequestPathToFileById(fileId, modifiedWhen, folder);
        if (requestFilePath.isPresent()) {
            return new FileData(Files.readAllBytes(requestFilePath.get()), requestFilePath.get().getFileName().toString());
        }
        return null;
    }

    @Nullable
    public byte[] resolveParametersInMultipartFile(MultipartFile file, SaveRequestResolvingContext resolvingContext) {
        try {
            Optional<String> fileBody = FileUtils.readFileToString(file);
            if (fileBody.isPresent()) {
                return this.replacer.replace(fileBody.get(), resolvingContext.mergeScopes()).getBytes();
            }
            return file.getBytes();
        }
        catch (IOException e) {
            log.error(" Failed to read file with name '{}' and content type '{}' for resolving parameters", (Object)file.getOriginalFilename(), (Object)file.getContentType());
            log.warn("File '{}' body is empty.", (Object)file.getOriginalFilename());
            return null;
        }
    }

    public Optional<MultipartFile> getFileAsMultipartFileByRequestId(UUID requestId, Date modifiedWhen, Path folder) throws IOException {
        FileData fileData = this.getRequestFileData(requestId, modifiedWhen, folder);
        if (fileData == null) {
            return Optional.empty();
        }
        try {
            DiskFileItem fileItem = (DiskFileItem)new DiskFileItemFactory().createItem(null, fileData.getContentType(), true, fileData.getFileName());
            IOUtils.copy((InputStream)new ByteArrayInputStream(fileData.getContent()), (OutputStream)fileItem.getOutputStream());
            return Optional.of(new CommonsMultipartFile((FileItem)fileItem));
        }
        catch (Exception exception) {
            log.warn("Can't read file with name {} by request id {}", (Object)fileData.getFileName(), (Object)requestId);
            return Optional.empty();
        }
    }

    public Optional<Path> getRequestPathToFile(UUID requestId, Date modifiedWhen, Path folder) throws IOException {
        Optional<Path> requestFilePath = this.getPathToFile(requestId, modifiedWhen, folder);
        if (requestFilePath.isPresent()) {
            return requestFilePath;
        }
        Optional<FileData> fileDataOptional = this.gridFsService.downloadFile(requestId);
        if (fileDataOptional.isPresent()) {
            FileData fileData = fileDataOptional.get();
            return Optional.of(FileUtils.saveFileDataDictionaryToFileSystem(folder, requestId, fileData));
        }
        return Optional.empty();
    }

    public Optional<Path> getRequestPathToFileById(UUID fileId, Date modifiedWhen, Path folder) throws IOException {
        Optional<Path> filePathOptional;
        Path requestFilePath = Paths.get(folder.toString(), fileId.toString());
        if (Files.exists(requestFilePath, new LinkOption[0]) && (filePathOptional = Files.list(requestFilePath).filter(file -> !Files.isDirectory(file, new LinkOption[0])).findFirst()).isPresent() && !this.needUpdateFileFromGridFs(filePathOptional.get(), modifiedWhen)) {
            return filePathOptional;
        }
        Optional<FileData> fileDataOptional = this.gridFsService.downloadFileByFileId(fileId);
        if (fileDataOptional.isPresent()) {
            FileData fileData = fileDataOptional.get();
            return Optional.of(FileUtils.saveFileDataDictionaryToFileSystem(folder, fileId, fileData));
        }
        return Optional.empty();
    }

    public Optional<FileBody> copyFileForCopiedRequest(UUID oldRequestId, Date modifiedWhen, UUID newRequestId, Path folder) throws IOException {
        Optional<Path> oldPathToFile = this.getRequestPathToFile(oldRequestId, modifiedWhen, folder);
        if (oldPathToFile.isPresent()) {
            Path newPathToDirectory = Paths.get(folder.toString(), newRequestId.toString());
            Files.createDirectories(newPathToDirectory, new FileAttribute[0]);
            String fileName = oldPathToFile.get().getFileName().toString();
            Path newPathToFile = Paths.get(newPathToDirectory.toString(), fileName);
            Files.copy(oldPathToFile.get(), newPathToFile, new CopyOption[0]);
            log.info("File by path '{}' was copied to '{}'", (Object)oldPathToFile.get(), (Object)newPathToFile);
            FileBody fileInfo = this.gridFsService.saveBinaryByRequestId(LocalDateTime.now().toString(), newRequestId, Files.newInputStream(newPathToFile.toFile().toPath(), new OpenOption[0]), fileName, Files.probeContentType(newPathToFile));
            log.debug("File for request {} was saved with parameters {}", (Object)newRequestId, (Object)fileInfo);
            return Optional.of(fileInfo);
        }
        return Optional.empty();
    }

    public FileBody uploadFileForRequest(UUID requestId, Path folder, MultipartFile file) throws IOException {
        FileUtils.prepareDirectoriesBeforeSave(folder, requestId);
        FileUtils.saveMultipartFileDictionaryToFileSystem(folder, requestId, file);
        this.gridFsService.removeBinaryFileByRequestId(requestId);
        FileBody fileInfo = this.gridFsService.saveBinaryByRequestId(LocalDateTime.now().toString(), requestId, file.getInputStream(), file.getOriginalFilename(), file.getContentType());
        log.debug("File for request {} was saved with parameters {}", (Object)requestId, (Object)fileInfo);
        return fileInfo;
    }

    private Optional<Path> getPathToFile(UUID requestId, Date modifiedWhen, Path folder) throws IOException {
        Optional<Path> filePathOptional;
        Path requestFilePath = Paths.get(folder.toString(), requestId.toString());
        if (Files.exists(requestFilePath, new LinkOption[0]) && (filePathOptional = Files.list(requestFilePath).filter(file -> !Files.isDirectory(file, new LinkOption[0])).findFirst()).isPresent() && !this.needUpdateFileFromGridFs(filePathOptional.get(), modifiedWhen)) {
            return filePathOptional;
        }
        return Optional.empty();
    }

    private boolean needUpdateFileFromGridFs(Path filePath, Date requestModifiedWhen) {
        File file = filePath.toFile();
        if (file.exists()) {
            long lastModifiedFile = file.lastModified();
            return requestModifiedWhen.after(new Date(lastModifiedFile)) || new Date().after(new Date(lastModifiedFile + (long)Integer.parseInt(this.cleanFileCacheTimeout) * 1000L));
        }
        return false;
    }

    public ItfLiteFileService(GridFsService gridFsService, ContextVariablesReplacer replacer) {
        this.gridFsService = gridFsService;
        this.replacer = replacer;
    }
}

