/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.persistence.EntityNotFoundException;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.CollectionRunNextRequestRepository;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.CollectionRunRequestsCountRepository;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.CollectionRunRequestsRepository;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.CollectionRunStackRequestsRepository;
import org.qubership.atp.itf.lite.backend.model.entities.collection.run.CollectionRunNextRequest;
import org.qubership.atp.itf.lite.backend.model.entities.collection.run.CollectionRunRequest;
import org.qubership.atp.itf.lite.backend.model.entities.collection.run.CollectionRunRequestsCount;
import org.qubership.atp.itf.lite.backend.model.entities.collection.run.CollectionRunStackRequest;
import org.qubership.atp.itf.lite.backend.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NextRequestService {
    private static final Logger log = LoggerFactory.getLogger(NextRequestService.class);
    private final CollectionRunNextRequestRepository collectionRunNextRequestRepository;
    private final CollectionRunRequestsCountRepository collectionRunRequestsCountRepository;
    private final CollectionRunRequestsRepository collectionRunRequestsRepository;
    private final CollectionRunStackRequestsRepository collectionRunStackRequestsRepository;
    @Value(value="${request.execution.count.max}")
    private int maxExecutionCount;

    public boolean hasNextRequest(UUID testRunId) {
        log.debug("hasNextRequest (testRunId: {})", (Object)testRunId);
        return this.collectionRunNextRequestRepository.existsByCollectionRunId(testRunId);
    }

    public void setNextRequest(UUID testRunId, @Nullable String nextRequest) {
        log.debug("setNextRequest (testRunId: {}, nextRequest: {})", (Object)testRunId, (Object)nextRequest);
        this.collectionRunNextRequestRepository.save(new CollectionRunNextRequest(testRunId, nextRequest, new Date()));
    }

    public String getNextRequest(UUID testRunId) {
        log.debug("getNextRequest(testRunId: {})", (Object)testRunId);
        return this.collectionRunNextRequestRepository.getNextRequestByCollectionRunId(testRunId);
    }

    @Transactional
    public void deleteNextRequest(UUID testRunId) {
        log.debug("deleteNextRequest(testRunId: {})", (Object)testRunId);
        this.collectionRunNextRequestRepository.removeByCollectionRunId(testRunId);
    }

    public boolean isExecutionLimitExceeded(UUID testRunId, UUID requestId) {
        log.debug("isExecutionLimitExceeded(testRunId: {}, requestId: {})", (Object)testRunId, (Object)requestId);
        int executionCount = this.getCountOfRequestExecution(testRunId, requestId);
        return executionCount > this.maxExecutionCount;
    }

    public int getCountOfRequestExecution(UUID testRunId, UUID requestId) {
        log.debug("getCountOfRequestExecution(testRunId: {}, requestId: {})", (Object)testRunId, (Object)requestId);
        try {
            Integer count = this.collectionRunRequestsCountRepository.findCountByCollectionRunIdAndRequestId(testRunId, requestId);
            if (Objects.isNull(count)) {
                return 0;
            }
            return count;
        }
        catch (EntityNotFoundException ignore) {
            log.warn("Count not found by testRunId: {} and requestId: {}", (Object)testRunId, (Object)requestId);
            return 0;
        }
    }

    public boolean hasRequestInCollectionOrder(UUID testRunId, UUID requestId) {
        log.debug("hasRequestInCollectionOrder(testRunId: {}, requestId: {})", (Object)testRunId, (Object)requestId);
        return this.collectionRunRequestsRepository.existsByCollectionRunIdAndRequestId(testRunId, requestId);
    }

    public void incrementExecutionCount(UUID testRunId, UUID requestId) {
        log.debug("incrementExecutionCount(testRunId: {}, requestId: {})", (Object)testRunId, (Object)requestId);
        CollectionRunRequestsCount requestExecutionCount = this.collectionRunRequestsCountRepository.findByCollectionRunIdAndRequestId(testRunId, requestId);
        if (Objects.isNull(requestExecutionCount)) {
            requestExecutionCount = new CollectionRunRequestsCount(testRunId, requestId, null, 0, new Date());
        }
        requestExecutionCount.setCount(requestExecutionCount.getCount() + 1);
        this.collectionRunRequestsCountRepository.save(requestExecutionCount);
    }

    public void addRequestToCollectionOrder(UUID testRunId, UUID requestId, String requestName) {
        log.debug("addRequestToCollectionOrder(testRunId: {}, requestId: {})", (Object)testRunId, (Object)requestId);
        if (this.hasRequestInCollectionOrder(testRunId, requestId)) {
            log.debug("Request already in collection order table. (testRunId: {}, requestId: {})", (Object)testRunId, (Object)requestId);
            return;
        }
        int order = this.collectionRunRequestsRepository.countByCollectionRunId(testRunId) + 1;
        CollectionRunRequest execOrder = new CollectionRunRequest();
        execOrder.setCollectionRunId(testRunId);
        execOrder.setRequestId(requestId);
        execOrder.setRequestName(requestName);
        execOrder.setOrder(order);
        this.collectionRunRequestsRepository.save(execOrder);
    }

    @Nullable
    public CollectionRunRequest findInCollectionOrderNextRequest(UUID testRunId) {
        log.debug("findInCollectionOrderNextRequest(testRunId: {})", (Object)testRunId);
        String request = this.getNextRequest(testRunId);
        if (Objects.isNull(request)) {
            return null;
        }
        CollectionRunRequest collReq = this.collectionRunRequestsRepository.findFirstByCollectionRunIdAndRequestNameOrderByOrderDesc(testRunId, request);
        if (Objects.isNull(collReq)) {
            log.trace("CollectionRunRequest not found by name. RequestName: {}", (Object)request);
            try {
                log.trace("Try to cast next request to uuid. NextRequest: {}", (Object)request);
                UUID requestId = UUID.fromString(request);
                log.trace("Search CollectionRunRequest by requestId: {}", (Object)requestId);
                return this.collectionRunRequestsRepository.findFirstByCollectionRunIdAndRequestIdOrderByOrderDesc(testRunId, requestId);
            }
            catch (IllegalArgumentException ex) {
                log.debug("Provided request string is not in UUID format");
                return null;
            }
        }
        return collReq;
    }

    @Transactional
    public void createNewSubCollection(UUID testRunId, CollectionRunRequest collRun) {
        log.debug("createNewSubCollection(testRunId: {}, StartCollectionRequest: {})", (Object)testRunId, (Object)collRun);
        this.collectionRunStackRequestsRepository.removeByCollectionRunId(testRunId);
        List<CollectionRunRequest> subColl = this.collectionRunRequestsRepository.findAllByCollectionRunIdAndOrderGreaterThanEqualOrderByOrder(testRunId, collRun.getOrder());
        CollectionRunStackRequest newSubCollStack = StreamUtils.mapToClazz(subColl, CollectionRunStackRequest.class);
        this.collectionRunStackRequestsRepository.saveAll((Iterable)((Object)newSubCollStack));
    }

    @Transactional
    public CollectionRunStackRequest pop(UUID testRunId) {
        log.debug("pop(testRunId: {})", (Object)testRunId);
        CollectionRunStackRequest firstInStack = this.collectionRunStackRequestsRepository.findFirstByCollectionRunIdOrderByOrder(testRunId);
        log.trace("Found first request in collection execution stack - {}", (Object)firstInStack);
        if (Objects.nonNull(firstInStack)) {
            this.collectionRunStackRequestsRepository.delete(firstInStack);
        }
        return firstInStack;
    }

    public boolean isSubCollectionExists(UUID testRunId) {
        return this.collectionRunStackRequestsRepository.existsByCollectionRunId(testRunId);
    }

    public NextRequestService(CollectionRunNextRequestRepository collectionRunNextRequestRepository, CollectionRunRequestsCountRepository collectionRunRequestsCountRepository, CollectionRunRequestsRepository collectionRunRequestsRepository, CollectionRunStackRequestsRepository collectionRunStackRequestsRepository) {
        this.collectionRunNextRequestRepository = collectionRunNextRequestRepository;
        this.collectionRunRequestsCountRepository = collectionRunRequestsCountRepository;
        this.collectionRunRequestsRepository = collectionRunRequestsRepository;
        this.collectionRunStackRequestsRepository = collectionRunStackRequestsRepository;
    }
}

