/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.modelmapper.ModelMapper;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.CustomRequestExecutionRepository;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.RequestExecutionDetailsRepository;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.RequestExecutionRepository;
import org.qubership.atp.itf.lite.backend.enums.TestingStatus;
import org.qubership.atp.itf.lite.backend.enums.ValueType;
import org.qubership.atp.itf.lite.backend.enums.http.RequestBodyType;
import org.qubership.atp.itf.lite.backend.exceptions.jsengine.ItfLiteScriptEnginePostScriptExecutionException;
import org.qubership.atp.itf.lite.backend.exceptions.jsengine.ItfLiteScriptEnginePreScriptExecutionException;
import org.qubership.atp.itf.lite.backend.feign.dto.PostmanExecuteScriptResponseDto;
import org.qubership.atp.itf.lite.backend.model.api.request.HttpRequestEntitySaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestEntitySaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.response.JsExecutionResult;
import org.qubership.atp.itf.lite.backend.model.api.response.RequestExecutionResponse;
import org.qubership.atp.itf.lite.backend.model.entities.FileBody;
import org.qubership.atp.itf.lite.backend.model.entities.gridfs.FileData;
import org.qubership.atp.itf.lite.backend.model.entities.history.HistoryRequestBody;
import org.qubership.atp.itf.lite.backend.model.entities.history.HistoryRequestDetailsResponse;
import org.qubership.atp.itf.lite.backend.model.entities.history.HistorySearchRequest;
import org.qubership.atp.itf.lite.backend.model.entities.history.HttpRequestExecutionDetails;
import org.qubership.atp.itf.lite.backend.model.entities.history.PaginatedResponse;
import org.qubership.atp.itf.lite.backend.model.entities.history.RequestExecution;
import org.qubership.atp.itf.lite.backend.model.entities.history.RequestExecutionDetails;
import org.qubership.atp.itf.lite.backend.model.entities.history.TestStatus;
import org.qubership.atp.itf.lite.backend.model.entities.http.FormDataPart;
import org.qubership.atp.itf.lite.backend.service.CrudService;
import org.qubership.atp.itf.lite.backend.service.GridFsService;
import org.qubership.atp.itf.lite.backend.service.UserService;
import org.qubership.atp.itf.lite.backend.utils.RequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class RequestExecutionHistoryService
extends CrudService<RequestExecution> {
    private static final Logger log = LoggerFactory.getLogger(RequestExecutionHistoryService.class);
    private final ModelMapper modelMapper = new ModelMapper();
    private final UserService userService;
    private final RequestExecutionDetailsRepository detailsRepository;
    private final CustomRequestExecutionRepository customRequestExecutionRepository;
    private final RequestExecutionRepository requestExecutionRepository;
    private final GridFsService gridFsService;

    @Override
    protected JpaRepository<RequestExecution, UUID> repository() {
        return this.requestExecutionRepository;
    }

    @Transactional
    public void logRequestExecution(String token, UUID sseId, RequestEntitySaveRequest request, RequestExecutionResponse response, Exception errorMessage, List<FileData> formDataFiles) {
        if (request instanceof HttpRequestEntitySaveRequest) {
            this.logHttpRequestExecution(token, sseId, (HttpRequestEntitySaveRequest)request, response, errorMessage, formDataFiles);
        }
    }

    @Transactional
    public JsExecutionResult logRequestJsExecution(String token, UUID sseId, RequestEntitySaveRequest request, PostmanExecuteScriptResponseDto jsExecutionResults, boolean isPreScript) {
        Optional<RequestExecutionDetails> detailsOptional = this.detailsRepository.findByRequestExecutionSseId(sseId);
        RequestExecutionDetails details = detailsOptional.orElseGet(() -> this.generateAndConfigureRequestExecutionDetails(request, token, sseId));
        if (request instanceof HttpRequestEntitySaveRequest && ((HttpRequestEntitySaveRequest)request).getBody() != null && RequestBodyType.GraphQL.equals((Object)((HttpRequestEntitySaveRequest)request).getBody().getType())) {
            HistoryRequestBody requestBody = new HistoryRequestBody();
            requestBody.setContent(((HttpRequestEntitySaveRequest)request).getBody().computeAndGetContent());
            requestBody.setType(RequestBodyType.GraphQL);
            details.setRequestBody(requestBody);
        }
        JsExecutionResult returnValue = new JsExecutionResult(true, null);
        if (Objects.nonNull(jsExecutionResults)) {
            log.info("Write JS script execution into DB");
            if (jsExecutionResults.getTestResults() != null) {
                ArrayList<TestStatus> testsStatuses = new ArrayList<TestStatus>();
                jsExecutionResults.getTestResults().forEach(testResult -> {
                    Boolean skipped;
                    boolean isFailed;
                    log.debug("Logging JS script execution into DB: {}", testResult);
                    boolean bl = isFailed = testResult.getPassed() == false || testResult.getError() != null;
                    if (isFailed) {
                        returnValue.setPassed(false);
                    }
                    if (Objects.isNull(skipped = testResult.getSkipped()) || !skipped.booleanValue()) {
                        testsStatuses.add(new TestStatus(testResult.getName(), isFailed ? TestingStatus.FAILED : TestingStatus.PASSED, isFailed ? testResult.getError().getMessage() : ""));
                    }
                });
                List<TestStatus> tests = details.getRequestTests();
                if (Objects.nonNull(tests)) {
                    tests.addAll(testsStatuses);
                } else {
                    tests = testsStatuses;
                }
                details.setRequestTests(tests);
                details.getRequestExecution().setTestingStatus(returnValue.isPassed() ? TestingStatus.PASSED : TestingStatus.FAILED);
            }
            if (jsExecutionResults.getConsoleLogs() != null) {
                jsExecutionResults.getConsoleLogs().forEach(details::addConsoleLog);
                returnValue.setConsoleLogs(jsExecutionResults.getConsoleLogs());
            }
            if (!returnValue.isPassed()) {
                if (isPreScript) {
                    details.setErrorMessage(RequestUtils.getErrorResponse((Exception)((Object)new ItfLiteScriptEnginePreScriptExecutionException())));
                } else {
                    details.setErrorMessage(RequestUtils.getErrorResponse((Exception)((Object)new ItfLiteScriptEnginePostScriptExecutionException())));
                }
            }
            this.detailsRepository.save(details);
        }
        return returnValue;
    }

    public RequestExecutionDetails generateAndConfigureRequestExecutionDetails(RequestEntitySaveRequest request, String token, UUID sseId) {
        HttpRequestExecutionDetails details = new HttpRequestExecutionDetails();
        String executor = this.getUserInformation(token);
        RequestExecution execution = new RequestExecution(executor, sseId, request, null, null);
        details.setRequestExecution(execution);
        return details;
    }

    @Transactional
    public void logHttpRequestExecution(String token, UUID sseId, HttpRequestEntitySaveRequest request, RequestExecutionResponse response, Exception errorMessage, List<FileData> formDataFiles) {
        RequestExecutionDetails details;
        Optional<RequestExecutionDetails> detailsOptional = this.detailsRepository.findByRequestExecutionSseId(sseId);
        HistoryRequestBody requestBody = null;
        boolean bodyExists = Objects.nonNull(request.getBody());
        if (request.getFile() != null && request.getFile().getContent() != null) {
            FileData fileData = request.getFile();
            UUID fileId = this.gridFsService.saveHistoryBinary(LocalDateTime.now().toString(), new ByteArrayInputStream(fileData.getContent()), fileData.getFileName());
            requestBody = new HistoryRequestBody();
            requestBody.setBinaryBody(new FileBody(fileData.getFileName(), fileId));
            requestBody.setType(bodyExists ? request.getBody().getType() : RequestBodyType.Binary);
        } else if (bodyExists) {
            requestBody = new HistoryRequestBody();
            requestBody.setType(request.getBody().getType());
            requestBody.setContent(request.getBody().getContent());
            if (Objects.nonNull(request.getBody().getFormDataBody())) {
                request.getBody().getFormDataBody().stream().filter(fdb -> ValueType.FILE.equals((Object)fdb.getType()) && Objects.nonNull(fdb.getFileId())).forEach(fdb -> fdb.setFileId(this.gridFsService.copyFileById(fdb.getFileId(), sseId)));
                this.fillFormDataParts(sseId, request.getBody().getFormDataBody(), formDataFiles);
                requestBody.setFormDataBody(request.getBody().getFormDataBody());
            }
        }
        if (detailsOptional.isPresent()) {
            details = detailsOptional.get();
            RequestExecution execution = details.getRequestExecution();
            execution.update(request, response);
            ((HttpRequestExecutionDetails)details).update(execution, request, response, errorMessage, requestBody);
        } else {
            String executor = this.getUserInformation(token);
            RequestExecution execution = new RequestExecution(executor, sseId, request, response, null);
            details = new HttpRequestExecutionDetails(execution, request, response, errorMessage, requestBody);
        }
        this.detailsRepository.save(details);
    }

    private void fillFormDataParts(UUID sseId, List<FormDataPart> formDataParts, List<FileData> files) {
        if (!CollectionUtils.isEmpty(formDataParts) && !CollectionUtils.isEmpty(files)) {
            int i = 0;
            for (FormDataPart fdp : formDataParts) {
                if (!ValueType.FILE.equals((Object)fdp.getType()) || !Objects.isNull(fdp.getFileId()) || i >= files.size()) continue;
                FileData f = files.get(i);
                if (Objects.nonNull(f)) {
                    UUID fileId = UUID.randomUUID();
                    fdp.setFileId(fileId);
                    fdp.setFileSize(f.getContent().length);
                    this.gridFsService.saveFileByRequestId(LocalDateTime.now().toString(), sseId, new ByteArrayInputStream(f.getContent()), f.getFileName(), fileId);
                }
                ++i;
            }
        }
    }

    public String getUserInformation(String token) {
        UserInfo userInfo = this.userService.getUserInfoByToken(token);
        String executor = Objects.isNull(userInfo) ? "Unknown User" : userInfo.getFirstName() + " " + userInfo.getLastName();
        return executor;
    }

    public PaginatedResponse<RequestExecution> getExecutionHistory(HistorySearchRequest request) {
        return this.customRequestExecutionRepository.findAllRequestExecutions(request);
    }

    public HistoryRequestDetailsResponse getExecutionHistoryDetailsByHistoryItemId(UUID historyItemId) {
        RequestExecution requestExecution = (RequestExecution)this.get(historyItemId);
        RequestExecutionDetails requestExecutionDetails = this.detailsRepository.findByRequestExecution(requestExecution);
        HistoryRequestDetailsResponse historyRequestDetailsResponse = (HistoryRequestDetailsResponse)this.modelMapper.map((Object)requestExecutionDetails, HistoryRequestDetailsResponse.class);
        if (requestExecutionDetails.getErrorMessage() != null) {
            historyRequestDetailsResponse.setErrorMessage(requestExecutionDetails.getErrorMessage().getMessage());
        }
        if (Objects.isNull(historyRequestDetailsResponse.getResponseBody()) && Objects.nonNull(requestExecutionDetails.getResponseBodyByte())) {
            historyRequestDetailsResponse.setResponseBody(new String(requestExecutionDetails.getResponseBodyByte(), StandardCharsets.UTF_8));
        }
        return historyRequestDetailsResponse;
    }

    public void getBinaryFileHistory(UUID fileId, HttpServletResponse response) throws IOException {
        log.debug("Start download file by id {}", (Object)fileId);
        Optional<FileData> requestBinaryFile = this.gridFsService.downloadFileByFileId(fileId);
        if (!requestBinaryFile.isPresent()) {
            log.warn("File with id {} not found", (Object)fileId);
            response.setStatus(HttpStatus.NOT_FOUND.value());
            return;
        }
        ServletOutputStream responseOutputStream = response.getOutputStream();
        responseOutputStream.write(requestBinaryFile.get().getContent());
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", requestBinaryFile.get().getFileName()));
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.flushBuffer();
    }

    public RequestExecutionDetails getExecutionHistoryDetailsBySseId(UUID sseId) {
        return this.detailsRepository.findByRequestExecutionSseId(sseId).orElse(null);
    }

    @Transactional
    public int cleanUpRequestExecutionHistory(int shift) {
        Calendar calendar = Calendar.getInstance();
        int minusDays = shift > 0 ? shift * -1 : shift;
        calendar.add(5, minusDays);
        return this.requestExecutionRepository.deleteByExecutedWhenBefore(new Timestamp(calendar.getTimeInMillis()));
    }

    public List<String> getExecutorsInRequestExecutionHistory(UUID projectId) {
        return this.requestExecutionRepository.findByProjectId(projectId);
    }

    public RequestExecutionHistoryService(UserService userService, RequestExecutionDetailsRepository detailsRepository, CustomRequestExecutionRepository customRequestExecutionRepository, RequestExecutionRepository requestExecutionRepository, GridFsService gridFsService) {
        this.userService = userService;
        this.detailsRepository = detailsRepository;
        this.customRequestExecutionRepository = customRequestExecutionRepository;
        this.requestExecutionRepository = requestExecutionRepository;
        this.gridFsService = gridFsService;
    }
}

