/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import java.util.UUID;
import org.qubership.atp.itf.lite.backend.enums.ImportToolType;
import org.qubership.atp.itf.lite.backend.enums.RequestExportStatus;
import org.qubership.atp.itf.lite.backend.model.api.kafka.ItfExportResponseEvent;
import org.qubership.atp.itf.lite.backend.model.api.kafka.MiaExportResponseEvent;
import org.qubership.atp.itf.lite.backend.service.kafka.KafkaExportEventExceptionResponseSendingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RequestExportExceptionResponseService {
    private static final Logger log = LoggerFactory.getLogger(RequestExportExceptionResponseService.class);
    private final KafkaExportEventExceptionResponseSendingService kafkaExportEventExceptionResponseSendingService;

    public void sendExceptionResponseEvent(ImportToolType importToolType, UUID exportRequestId, UUID requestId, String errorMessage) {
        if (ImportToolType.MIA.equals((Object)importToolType)) {
            this.sendMiaExportExceptionResponseEvent(exportRequestId, requestId, errorMessage);
        } else {
            this.sendItfExportExceptionResponseEvent(exportRequestId, requestId, errorMessage);
        }
    }

    private void sendMiaExportExceptionResponseEvent(UUID exportRequestId, UUID requestId, String errorMessage) {
        log.debug("Send export finish response for exportRequestId = {}, requestId = {}", (Object)exportRequestId, (Object)requestId);
        MiaExportResponseEvent miaExportResponseEvent = new MiaExportResponseEvent();
        miaExportResponseEvent.setId(exportRequestId);
        miaExportResponseEvent.setRequestId(requestId);
        miaExportResponseEvent.setErrorMessage(errorMessage);
        miaExportResponseEvent.setStatus(RequestExportStatus.ERROR.name());
        this.kafkaExportEventExceptionResponseSendingService.miaFinishExportResponseEventSend(miaExportResponseEvent);
    }

    private void sendItfExportExceptionResponseEvent(UUID exportRequestId, UUID requestId, String errorMessage) {
        log.debug("Send export finish response for exportRequestId = {}, requestId = {}", (Object)exportRequestId, (Object)requestId);
        ItfExportResponseEvent itfExportResponseEvent = new ItfExportResponseEvent();
        itfExportResponseEvent.setId(exportRequestId);
        itfExportResponseEvent.setRequestId(requestId);
        itfExportResponseEvent.setErrorMessage(errorMessage);
        itfExportResponseEvent.setStatus(RequestExportStatus.ERROR.name());
        this.kafkaExportEventExceptionResponseSendingService.itfFinishExportResponseEventSend(itfExportResponseEvent);
    }

    public RequestExportExceptionResponseService(KafkaExportEventExceptionResponseSendingService kafkaExportEventExceptionResponseSendingService) {
        this.kafkaExportEventExceptionResponseSendingService = kafkaExportEventExceptionResponseSendingService;
    }
}

