/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.integration.configuration.model.notification.Notification;
import org.qubership.atp.integration.configuration.service.NotificationService;
import org.qubership.atp.itf.lite.backend.components.export.RequestExportStrategiesRegistry;
import org.qubership.atp.itf.lite.backend.components.export.strategies.request.RequestExportStrategy;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.RequestExportRepository;
import org.qubership.atp.itf.lite.backend.enums.ImportToolType;
import org.qubership.atp.itf.lite.backend.enums.RequestExportStatus;
import org.qubership.atp.itf.lite.backend.enums.TransportType;
import org.qubership.atp.itf.lite.backend.exceptions.requests.ItfLiteExportRequestException;
import org.qubership.atp.itf.lite.backend.mdc.ItfLiteMdcField;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestExportRequest;
import org.qubership.atp.itf.lite.backend.model.api.response.RequestExportResultResponse;
import org.qubership.atp.itf.lite.backend.model.entities.Request;
import org.qubership.atp.itf.lite.backend.model.entities.RequestExportEntity;
import org.qubership.atp.itf.lite.backend.service.CrudService;
import org.qubership.atp.itf.lite.backend.service.RequestExportExceptionResponseService;
import org.qubership.atp.itf.lite.backend.service.RequestService;
import org.qubership.atp.itf.lite.backend.service.SseEmitterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Service
public class RequestExportService
extends CrudService<RequestExportEntity> {
    private static final Logger log = LoggerFactory.getLogger(RequestExportService.class);
    private final RequestExportRepository repository;
    private final RequestExportStrategiesRegistry exportStrategiesRegistry;
    private final RequestService requestService;
    private final SseEmitterService sseEmitterService;
    private final NotificationService notificationService;
    private final RequestExportExceptionResponseService requestExportExceptionResponseService;

    public void exportRequests(UUID sseId, UUID userId, RequestExportRequest exportRequest, ImportToolType importToolType, String context, UUID environmentId) {
        UUID exportRequestId = UUID.randomUUID();
        try {
            List<Request> requests = this.requestService.getAllRequestsByProjectIdFolderIdsRequestIds(exportRequest.getProjectId(), null, exportRequest.getRequestIds());
            this.saveExportRequest(exportRequestId, sseId, userId, exportRequest);
            for (Request request : requests) {
                MdcUtils.put((String)ItfLiteMdcField.REQUEST_ID.toString(), (UUID)request.getId());
                TransportType requestTransportType = request.getTransportType();
                try {
                    RequestExportStrategy exportStrategy = this.exportStrategiesRegistry.getStrategy(importToolType, requestTransportType);
                    exportStrategy.export(exportRequestId, exportRequest, request, context, environmentId);
                }
                catch (Exception err) {
                    this.processExceptionDuringExport(exportRequestId, sseId, request.getId(), importToolType, err);
                }
                MDC.remove((String)ItfLiteMdcField.REQUEST_ID.toString());
            }
        }
        catch (Exception e) {
            String errorMessage = "Failed to export requests.\n" + e.getMessage();
            log.error("Failed to export requests", (Throwable)e);
            this.removeFinishedExport(exportRequestId);
            SseEmitter emitter = this.sseEmitterService.getEmitter(sseId);
            if (emitter != null) {
                this.sseEmitterService.emitterCompleteWithError(emitter, (Exception)((Object)new ItfLiteExportRequestException()));
            } else {
                log.debug("Send kafka event for each request, exportRequestId = {}", (Object)exportRequestId);
                exportRequest.getRequestIds().forEach(requestId -> this.requestExportExceptionResponseService.sendExceptionResponseEvent(importToolType, exportRequestId, (UUID)requestId, errorMessage));
            }
            log.debug("Send notification about failed export with exportRequestId = {}", (Object)exportRequestId);
            Notification notification = new Notification(errorMessage, Notification.Type.ERROR, userId);
            this.notificationService.sendNotification(notification);
        }
    }

    private void processExceptionDuringExport(UUID exportRequestId, UUID sseId, UUID requestId, ImportToolType importToolType, Exception err) throws IOException {
        log.error("Failed to export request with id '{}'\n{}", new Object[]{requestId, err.getMessage(), err});
        SseEmitter emitter = this.sseEmitterService.getEmitter(sseId);
        if (emitter != null) {
            RequestExportEntity requestExportEntity = this.findByRequestExportId(exportRequestId);
            RequestExportResultResponse exportResultWithError = RequestExportResultResponse.builder().requestId(requestId).errorDescription(err.getMessage()).status(RequestExportStatus.ERROR).build();
            this.processExportResult(requestExportEntity, exportResultWithError, emitter, importToolType);
        } else {
            this.requestExportExceptionResponseService.sendExceptionResponseEvent(importToolType, exportRequestId, requestId, err.getMessage());
        }
    }

    public void saveExportRequest(UUID requestExportId, UUID sseId, UUID userId, RequestExportRequest requestExportRequest) {
        RequestExportEntity requestExportEntity = new RequestExportEntity();
        requestExportEntity.setRequestExportId(requestExportId);
        requestExportEntity.setSseId(sseId);
        requestExportEntity.setUserId(userId);
        HashMap<UUID, RequestExportStatus> requestStatuses = new HashMap<UUID, RequestExportStatus>();
        requestExportRequest.getRequestIds().forEach(requestId -> requestStatuses.put((UUID)requestId, RequestExportStatus.IN_PROGRESS));
        requestExportEntity.setRequestStatuses(requestStatuses);
        requestExportEntity.setDestination(requestExportRequest.getDestination());
        this.save(requestExportEntity);
    }

    public void updateRequestIdStatus(RequestExportEntity requestExportEntity, UUID requestId, RequestExportStatus status) {
        if (!CollectionUtils.isEmpty(requestExportEntity.getRequestStatuses())) {
            Map<UUID, RequestExportStatus> requestStatuses = requestExportEntity.getRequestStatuses();
            requestStatuses.put(requestId, status);
            this.save(requestExportEntity);
            return;
        }
        log.error("Request export entity with export id = {} has empty request statuses map", (Object)requestExportEntity.getRequestExportId());
    }

    public boolean isExportFinished(RequestExportEntity requestExportEntity) {
        Map<UUID, RequestExportStatus> requestStatuses = requestExportEntity.getRequestStatuses();
        return requestStatuses.entrySet().stream().allMatch(entry -> entry.getValue() == RequestExportStatus.DONE || entry.getValue() == RequestExportStatus.ERROR);
    }

    public void removeFinishedExport(UUID requestExportId) {
        this.repository.deleteByRequestExportId(requestExportId);
    }

    public RequestExportEntity findByRequestExportId(UUID requestExportId) {
        return this.repository.findByRequestExportId(requestExportId);
    }

    @Transactional
    public void processExportResult(RequestExportEntity requestExportEntity, RequestExportResultResponse exportResult, SseEmitter sseEmitter, ImportToolType importToolType) throws IOException {
        log.debug("Send sse event with export result for sseId = {}", (Object)requestExportEntity.getSseId());
        this.updateRequestIdStatus(requestExportEntity, exportResult.getRequestId(), exportResult.getStatus());
        this.sseEmitterService.sendEventWithExportResult(requestExportEntity.getSseId(), sseEmitter, importToolType, exportResult);
        if (this.isExportFinished(requestExportEntity)) {
            String message = String.format("Export to %s process is finished. Destination = %s", importToolType.name(), requestExportEntity.getDestination());
            Notification notification = new Notification(message, Notification.Type.INFO, requestExportEntity.getUserId());
            this.removeFinishedExport(requestExportEntity.getRequestExportId());
            sseEmitter.complete();
            this.notificationService.sendNotification(notification);
        }
    }

    @Override
    protected JpaRepository<RequestExportEntity, UUID> repository() {
        return this.repository;
    }

    public RequestExportService(RequestExportRepository repository, RequestExportStrategiesRegistry exportStrategiesRegistry, RequestService requestService, SseEmitterService sseEmitterService, NotificationService notificationService, RequestExportExceptionResponseService requestExportExceptionResponseService) {
        this.repository = repository;
        this.exportStrategiesRegistry = exportStrategiesRegistry;
        this.requestService = requestService;
        this.sseEmitterService = sseEmitterService;
        this.notificationService = notificationService;
        this.requestExportExceptionResponseService = requestExportExceptionResponseService;
    }
}

