/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import java.util.UUID;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.RequestHeaderRepository;
import org.qubership.atp.itf.lite.backend.model.entities.http.RequestHeader;
import org.qubership.atp.itf.lite.backend.service.CrudService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class RequestHeaderService
extends CrudService<RequestHeader> {
    private static final Logger log = LoggerFactory.getLogger(RequestHeaderService.class);
    private final RequestHeaderRepository repository;

    public void disableRequestHeader(UUID headerId) {
        log.info("Disable request header with id '{}'", (Object)headerId);
        RequestHeader header = (RequestHeader)this.get(headerId);
        header.setDisabled(true);
        this.repository.save(header);
    }

    public void enableRequestHeader(UUID headerId) {
        log.info("Enable request header with id '{}'", (Object)headerId);
        RequestHeader header = (RequestHeader)this.get(headerId);
        header.setDisabled(false);
        this.repository.save(header);
    }

    @Override
    protected JpaRepository<RequestHeader, UUID> repository() {
        return this.repository;
    }

    public RequestHeaderService(RequestHeaderRepository repository) {
        this.repository = repository;
    }
}

