/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import java.util.UUID;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.RequestParamRepository;
import org.qubership.atp.itf.lite.backend.model.entities.http.RequestParam;
import org.qubership.atp.itf.lite.backend.service.CrudService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class RequestParamService
extends CrudService<RequestParam> {
    private static final Logger log = LoggerFactory.getLogger(RequestParamService.class);
    private final RequestParamRepository repository;

    public void disableRequestParam(UUID paramId) {
        log.info("Disable request param with id '{}'", (Object)paramId);
        RequestParam param = (RequestParam)this.get(paramId);
        param.setDisabled(true);
        this.repository.save(param);
    }

    public void enableRequestParam(UUID paramId) {
        log.info("Enable request param with id '{}'", (Object)paramId);
        RequestParam param = (RequestParam)this.get(paramId);
        param.setDisabled(false);
        this.repository.save(param);
    }

    @Override
    protected JpaRepository<RequestParam, UUID> repository() {
        return this.repository;
    }

    public RequestParamService(RequestParamRepository repository) {
        this.repository = repository;
    }
}

