/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.transaction.Transactional;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.RequestSnapshotRepository;
import org.qubership.atp.itf.lite.backend.enums.TransportType;
import org.qubership.atp.itf.lite.backend.model.api.request.BulkDeleteSnapshotsRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestEntitySaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.AuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.response.FileInfoResponse;
import org.qubership.atp.itf.lite.backend.model.api.response.RequestSnapshotResponse;
import org.qubership.atp.itf.lite.backend.model.entities.FileBody;
import org.qubership.atp.itf.lite.backend.model.entities.Request;
import org.qubership.atp.itf.lite.backend.model.entities.RequestSnapshot;
import org.qubership.atp.itf.lite.backend.model.entities.auth.RequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.gridfs.FileInfo;
import org.qubership.atp.itf.lite.backend.model.entities.key.RequestSnapshotKey;
import org.qubership.atp.itf.lite.backend.service.GridFsService;
import org.qubership.atp.itf.lite.backend.service.RequestAuthorizationService;
import org.qubership.atp.itf.lite.backend.service.RequestService;
import org.qubership.atp.itf.lite.backend.utils.AuthorizationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class RequestSnapshotService {
    private static final Logger log = LoggerFactory.getLogger(RequestSnapshotService.class);
    private final RequestService requestService;
    private final GridFsService gridFsService;
    private final ObjectMapper objectMapper;
    private final RequestAuthorizationService requestAuthorizationService;
    private final RequestSnapshotRepository repository;

    public RequestSnapshot saveSnapshot(RequestSnapshot requestSnapshot, List<MultipartFile> files, Optional<FileBody> fileInfo) throws JsonProcessingException {
        RequestSnapshot existingSnapshot;
        boolean isNewSnapshot;
        Request request = (Request)this.objectMapper.readValue(requestSnapshot.getRequest(), Request.class);
        RequestEntitySaveRequest requestEntitySaveRequest = (RequestEntitySaveRequest)this.objectMapper.readValue(requestSnapshot.getRequest(), RequestEntitySaveRequest.class);
        this.requestService.checkFilesSize(files);
        if (Objects.nonNull(requestEntitySaveRequest.getAuthorization())) {
            AuthorizationSaveRequest authorizationSaveRequest = requestEntitySaveRequest.getAuthorization();
            this.requestAuthorizationService.encryptAuthorizationParameters(authorizationSaveRequest);
            request.setAuthorization((RequestAuthorization)this.objectMapper.convertValue((Object)authorizationSaveRequest, AuthorizationUtils.getRequestAuthorizationClassByAuthorizationSaveRequest(authorizationSaveRequest)));
        }
        boolean bl = isNewSnapshot = (existingSnapshot = (RequestSnapshot)this.repository.findById(new RequestSnapshotKey(requestSnapshot.getSessionId(), requestSnapshot.getRequestId())).orElse(null)) == null;
        if (isNewSnapshot) {
            requestSnapshot.setCreatedWhen(new Date());
        }
        requestSnapshot.setRequest(this.objectMapper.writeValueAsString((Object)request));
        return (RequestSnapshot)this.repository.save(requestSnapshot);
    }

    public Optional<FileBody> saveFileToFileSystemAndGridFs(UUID sessionId, UUID sessionRequestId, MultipartFile file, TransportType transportType) throws IOException {
        this.gridFsService.removeFileBySessionId(sessionId);
        FileBody fileInfo = this.gridFsService.saveBinaryBySessionId(LocalDateTime.now().toString(), sessionId, sessionRequestId, file.getInputStream(), file.getOriginalFilename(), file.getContentType());
        log.debug("File for request {} was saved with parameters {}", (Object)sessionId, (Object)fileInfo);
        return Optional.of(fileInfo);
    }

    public RequestSnapshotResponse getSnapshot(UUID sessionId, UUID requestId) {
        FileInfo fileInfo;
        Optional requestSnapshotOpt = this.repository.findById(new RequestSnapshotKey(sessionId, requestId));
        if (!requestSnapshotOpt.isPresent()) {
            return null;
        }
        RequestSnapshot requestSnapshot = (RequestSnapshot)requestSnapshotOpt.get();
        UUID binaryFileId = requestSnapshot.getBinaryFileId();
        FileInfoResponse fileInfoResponse = null;
        if (binaryFileId != null && (fileInfo = this.gridFsService.getFileInfoByFileId(binaryFileId)) != null) {
            fileInfoResponse = FileInfoResponse.builder().fileId(binaryFileId).fileName(fileInfo.getFileName()).fileType(fileInfo.getFileType()).contentType(fileInfo.getContentType()).size(fileInfo.getSize()).build();
        }
        return RequestSnapshotResponse.builder().request(requestSnapshot.getRequest()).sessionId(sessionId).requestId(requestId).binaryFile(fileInfoResponse).build();
    }

    @Transactional
    public void deleteSnapshotByRequestSnapshotKey(UUID sessionId, UUID requestId) {
        this.repository.deleteBySessionIdAndRequestId(sessionId, requestId);
        this.gridFsService.removeAllFilesBySessionIdAndSessionRequestId(sessionId, requestId);
    }

    @Transactional
    public void bulkDeleteSnapshots(BulkDeleteSnapshotsRequest bulkDeleteSnapshotsRequest, UUID sessionId) {
        this.repository.deleteAllBySessionIdAndRequestIdIn(sessionId, bulkDeleteSnapshotsRequest.getRequestIds());
        this.gridFsService.bulkRemoveFilesBySnapshotKeys(sessionId, bulkDeleteSnapshotsRequest.getRequestIds());
    }

    @Transactional
    public void preSaveRequestProcessing(UUID sessionId, UUID requestId) {
        this.gridFsService.moveFileFromSnapshotToRequest(sessionId, requestId);
        this.repository.deleteBySessionIdAndRequestId(sessionId, requestId);
    }

    public List<RequestSnapshotKey> getByCreatedWhenDifferenceGreaterThanReferenceDate(Date referenceDate, Long expirationPeriod) {
        return this.repository.findAllByCreatedWhenDifferenceGreaterThanReferenceDate(referenceDate, expirationPeriod);
    }

    public RequestSnapshotService(RequestService requestService, GridFsService gridFsService, ObjectMapper objectMapper, RequestAuthorizationService requestAuthorizationService, RequestSnapshotRepository repository) {
        this.requestService = requestService;
        this.gridFsService = gridFsService;
        this.objectMapper = objectMapper;
        this.requestAuthorizationService = requestAuthorizationService;
        this.repository = repository;
    }
}

