/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import org.qubership.atp.itf.lite.backend.model.entities.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RequestSpecificationService {
    private static final Logger log = LoggerFactory.getLogger(RequestSpecificationService.class);
    private final String requestProjectIdFieldName = "projectId";
    private final String requestFolderIdFieldName = "folderId";
    private final String requestIdFieldName = "id";

    public Specification<Request> generateSpecificationToFilterRequestsByProjectIdFolderIdsRequestIds(UUID projectId, Set<UUID> folderIds, Set<UUID> requestIds) {
        return (Specification & Serializable)(root, query, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (projectId != null) {
                predicates.add(builder.equal((Expression)root.get("projectId"), (Object)projectId));
            }
            if (!CollectionUtils.isEmpty((Collection)folderIds)) {
                predicates.add(builder.or((Predicate[])folderIds.stream().map(value -> builder.equal((Expression)root.get("folderId"), value)).toArray(Predicate[]::new)));
            }
            if (!CollectionUtils.isEmpty((Collection)requestIds)) {
                predicates.add(builder.or((Predicate[])requestIds.stream().map(value -> builder.equal((Expression)root.get("id"), value)).toArray(Predicate[]::new)));
            }
            if (predicates.isEmpty()) {
                return builder.conjunction();
            }
            query.orderBy(new Order[]{builder.asc((Expression)root.get("order"))});
            return builder.and(predicates.toArray(new Predicate[0]));
        };
    }
}

