/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service.history.impl;

import java.util.UUID;
import org.javers.core.Javers;
import org.qubership.atp.itf.lite.backend.converters.history.AbstractVersioningMapper;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.FolderRepository;
import org.qubership.atp.itf.lite.backend.feign.dto.history.AbstractCompareEntityDto;
import org.qubership.atp.itf.lite.backend.feign.dto.history.HistoryItemTypeDto;
import org.qubership.atp.itf.lite.backend.model.entities.Folder;
import org.qubership.atp.itf.lite.backend.model.entities.Request;
import org.qubership.atp.itf.lite.backend.service.history.impl.AbstractRetrieveHistoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRequestRetrieveHistoryService<S extends Request, D extends AbstractCompareEntityDto>
extends AbstractRetrieveHistoryService<S, D> {
    private static final Logger log = LoggerFactory.getLogger(AbstractRequestRetrieveHistoryService.class);
    private final FolderRepository folderRepository;

    public AbstractRequestRetrieveHistoryService(Javers javers, AbstractVersioningMapper<S, D> abstractVersioningMapper, FolderRepository folderRepository) {
        super(javers, abstractVersioningMapper);
        this.folderRepository = folderRepository;
    }

    @Override
    public HistoryItemTypeDto getItemType() {
        return HistoryItemTypeDto.REQUEST;
    }

    String getFolderName(UUID folderId) {
        if (folderId != null) {
            Folder parentFolder = null;
            try {
                parentFolder = (Folder)this.folderRepository.getOne(folderId);
            }
            catch (Exception e) {
                log.error("Cannot get folder by folder id {}", (Object)folderId, (Object)e);
            }
            return parentFolder == null ? "Parent folder with ID #" + folderId + " has been deleted" : parentFolder.getName();
        }
        return "Root";
    }
}

