/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service.history.impl;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import org.hibernate.Hibernate;
import org.javers.core.Javers;
import org.javers.core.metamodel.annotation.DiffInclude;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.jql.QueryBuilder;
import org.javers.shadow.Shadow;
import org.modelmapper.ModelMapper;
import org.qubership.atp.itf.lite.backend.exceptions.history.ItfLiteRevisionHistoryIncorrectClassException;
import org.qubership.atp.itf.lite.backend.exceptions.history.ItfLiteRevisionHistoryNotFoundException;
import org.qubership.atp.itf.lite.backend.model.entities.AbstractNamedEntity;
import org.qubership.atp.itf.lite.backend.service.history.iface.EntityHistoryService;
import org.qubership.atp.itf.lite.backend.service.history.iface.RestoreHistoryService;
import org.qubership.atp.itf.lite.backend.service.history.impl.ValidateReferenceExistsService;
import org.springframework.util.CollectionUtils;

public abstract class AbstractRestoreHistoryService<E extends AbstractNamedEntity>
implements RestoreHistoryService {
    protected final Javers javers;
    protected final EntityHistoryService<E> entityHistoryService;
    private final ValidateReferenceExistsService validateReferenceExistsService;
    protected final ModelMapper modelMapper;
    public static final Predicate<Field> IS_DIFFINLCUDE_ANNOTATED_PROPERTY_FILTER = field -> field.isAnnotationPresent(DiffInclude.class);

    @Override
    public AbstractNamedEntity restoreToRevision(UUID id, long revisionId) {
        List<Shadow<E>> shadows = this.getShadows(id, revisionId);
        if (CollectionUtils.isEmpty(shadows)) {
            throw new ItfLiteRevisionHistoryNotFoundException(this.getItemType().toString(), Long.toString(revisionId), id.toString());
        }
        Shadow<E> objectShadow = shadows.iterator().next();
        this.updateObjectWithChild(objectShadow);
        AbstractNamedEntity actualObject = (AbstractNamedEntity)Hibernate.unproxy(this.getObject(id), this.getEntityClass());
        this.validateReferenceExistsService.validateEntity(actualObject);
        return this.saveRestoredObject((AbstractNamedEntity)this.restoreValues(objectShadow, actualObject));
    }

    protected Object restoreValues(Shadow<E> shadow, E actualObject) {
        AbstractNamedEntity snapshot = (AbstractNamedEntity)shadow.get();
        if (!actualObject.getClass().equals(snapshot.getClass())) {
            throw new ItfLiteRevisionHistoryIncorrectClassException(snapshot.getClass().toString(), actualObject.getClass().toString());
        }
        this.copyValues(snapshot, actualObject);
        return actualObject;
    }

    protected List<Predicate<Field>> getPredicates() {
        return Arrays.asList(IS_DIFFINLCUDE_ANNOTATED_PROPERTY_FILTER);
    }

    public E getObject(UUID id) {
        return this.entityHistoryService.get(id);
    }

    public AbstractNamedEntity saveRestoredObject(E object) {
        return this.entityHistoryService.restore(object);
    }

    abstract void updateObjectWithChild(Shadow<E> var1);

    public List<Shadow<E>> getShadows(UUID id, long revisionId) {
        JqlQuery query = QueryBuilder.byInstanceId((Object)id, this.getEntityClass()).withVersion(revisionId).build();
        List snapshots = this.javers.findSnapshots(query);
        QueryBuilder queryBuilder = QueryBuilder.byInstanceId((Object)id, this.getEntityClass()).withVersion(revisionId).withScopeDeepPlus();
        if (Objects.nonNull(snapshots) && snapshots.size() > 0) {
            queryBuilder.withCommitId(((CdoSnapshot)snapshots.get(0)).getCommitId());
        }
        return this.javers.findShadows(queryBuilder.build());
    }

    public abstract List<Shadow<Object>> getChildShadows(Shadow<E> var1, Class var2);

    protected abstract void copyValues(E var1, E var2);

    public AbstractRestoreHistoryService(Javers javers, EntityHistoryService<E> entityHistoryService, ValidateReferenceExistsService validateReferenceExistsService, ModelMapper modelMapper) {
        this.javers = javers;
        this.entityHistoryService = entityHistoryService;
        this.validateReferenceExistsService = validateReferenceExistsService;
        this.modelMapper = modelMapper;
    }
}

